/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.AtKt;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.at.io.AccessTransformFormat;
import paper.libs.org.cadixdev.at.io.AccessTransformFormats;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0007R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/MergeAccessTransforms;", "Lio/papermc/paperweight/tasks/BaseTask;", "<init>", "()V", "firstFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFirstFile", "()Lorg/gradle/api/file/RegularFileProperty;", "secondFile", "getSecondFile", "outputFile", "getOutputFile", "init", "", "run", "paperweight-lib"})
public abstract class MergeAccessTransforms
extends BaseTask {
    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getFirstFile();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getSecondFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    public void init() {
        this.getOutputFile().convention((Provider)UtilsKt.defaultOutput(this, "at"));
    }

    @TaskAction
    public final void run() {
        Object[] objectArray = new Path[]{FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getFirstFile())), FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getSecondFile()))};
        Sequence ats = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), MergeAccessTransforms::run$lambda$0), MergeAccessTransforms::run$lambda$1);
        AccessTransformSet outputAt = AccessTransformSet.create();
        for (AccessTransformSet at : ats) {
            outputAt.merge(at);
        }
        AccessTransformFormat accessTransformFormat = AccessTransformFormats.FML;
        Intrinsics.checkNotNullExpressionValue((Object)accessTransformFormat, (String)"FML");
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputFile()));
        Intrinsics.checkNotNull((Object)outputAt);
        AtKt.writeLF$default(accessTransformFormat, path, outputAt, null, 4, null);
    }

    private static final boolean run$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final AccessTransformSet run$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AccessTransformFormats.FML.read(it);
    }
}

