/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.JavaLauncherTask;
import io.papermc.paperweight.util.AsmUtil;
import io.papermc.paperweight.util.ClassNodeCache;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH&R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lio/papermc/paperweight/tasks/ScanJar;", "Lio/papermc/paperweight/tasks/JavaLauncherTask;", "<init>", "()V", "jarToScan", "Lorg/gradle/api/file/RegularFileProperty;", "getJarToScan", "()Lorg/gradle/api/file/RegularFileProperty;", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "log", "getLog", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "", "getJvmArgs", "()Lorg/gradle/api/provider/ListProperty;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "init", "", "run", "queue", "Lorg/gradle/workers/WorkQueue;", "Companion", "ScanJarAction", "paperweight-lib"})
public abstract class ScanJar
extends JavaLauncherTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Classpath
    @NotNull
    public abstract RegularFileProperty getJarToScan();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getLog();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmArgs();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void init() {
        super.init();
        this.setGroup("verification");
        this.getJvmArgs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx768m"));
        FileKt.set((FileSystemLocationProperty)this.getLog(), UtilsKt.getCache(this.getLayout()).resolve(ConstantsKt.paperTaskOutput((Task)this, "txt")));
    }

    @TaskAction
    public final void run() {
        Object object = this.getLauncher().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        JavaLauncher launcher = (JavaLauncher)object;
        Object object2 = this.getJvmArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List jvmArgs = (List)object2;
        WorkQueue queue2 = this.getWorkerExecutor().processIsolation(new Action(jvmArgs, launcher){
            final /* synthetic */ List<String> $jvmArgs;
            final /* synthetic */ JavaLauncher $launcher;
            {
                this.$jvmArgs = $jvmArgs;
                this.$launcher = $launcher;
            }

            public final void execute(ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$this$processIsolation");
                $this$processIsolation.getForkOptions().jvmArgs((Iterable)this.$jvmArgs);
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                RegularFile regularFile = this.$launcher.getExecutablePath();
                Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"getExecutablePath(...)");
                javaForkOptions.executable((Object)((Object)FileKt.getPath((FileSystemLocation)regularFile).toAbsolutePath()).toString());
            }
        });
        Intrinsics.checkNotNull((Object)queue2);
        this.queue(queue2);
    }

    public abstract void queue(@NotNull WorkQueue var1);

    static {
        Logger logger = Logging.getLogger(ScanJar.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ScanJar.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/tasks/ScanJar$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "paperweight-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H$R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/papermc/paperweight/tasks/ScanJar$ScanJarAction;", "P", "Lio/papermc/paperweight/tasks/ScanJar$ScanJarAction$BaseParameters;", "Lorg/gradle/workers/WorkAction;", "Lio/papermc/paperweight/util/AsmUtil;", "<init>", "()V", "log", "", "", "getLog", "()Ljava/util/List;", "execute", "", "scan", "Ljava/nio/file/FileSystem;", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "handleClass", "classNode", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "BaseParameters", "paperweight-lib"})
    @SourceDebugExtension(value={"SMAP\nScanJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanJar.kt\nio/papermc/paperweight/tasks/ScanJar$ScanJarAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1869#2,2:173\n1869#2,2:175\n*S KotlinDebug\n*F\n+ 1 ScanJar.kt\nio/papermc/paperweight/tasks/ScanJar$ScanJarAction\n*L\n103#1:173,2\n130#1:175,2\n*E\n"})
    public static abstract class ScanJarAction<P extends BaseParameters>
    implements WorkAction<P>,
    AsmUtil {
        @NotNull
        private final List<String> log = new ArrayList();

        @NotNull
        protected final List<String> getLog() {
            return this.log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() {
            Object object;
            Object object2 = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((BaseParameters)this.getParameters()).getJarToScan())));
            Object object3 = null;
            try {
                FileSystem scan2 = (FileSystem)object2;
                boolean bl = false;
                Exception fail = null;
                List classPathDirs = new ArrayList();
                List classPathJars = new ArrayList();
                Iterable $this$forEach$iv = (Iterable)((BaseParameters)this.getParameters()).getClasspath();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (it.isDirectory()) {
                        Path path = it.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        classPathDirs.add(path);
                        continue;
                    }
                    if (!it.isFile()) continue;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                    try {
                        Collection collection = classPathJars;
                        Path path = it.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        collection.add(FileKt.openZip(path));
                    }
                    catch (Exception ex) {
                        logger.error("Failed to open zip " + it, (Throwable)ex);
                        if (fail == null) {
                            fail = ex;
                            continue;
                        }
                        ExceptionsKt.addSuppressed((Throwable)fail, (Throwable)ex);
                    }
                }
                try {
                    if (fail != null) {
                        throw new PaperweightException("Failed to read classpath jars", fail);
                    }
                    ClassNodeCache classNodeCache = ClassNodeCache.Companion.create(scan2, classPathJars, classPathDirs);
                    this.scan(scan2, classNodeCache);
                }
                finally {
                    Exception err = null;
                    Iterable $this$forEach$iv2 = classPathJars;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        FileSystem it = (FileSystem)element$iv;
                        boolean bl3 = false;
                        try {
                            it.close();
                        }
                        catch (Exception ex) {
                            logger.error("Failed to close zip " + it, (Throwable)ex);
                            if (err == null) {
                                err = ex;
                                continue;
                            }
                            ExceptionsKt.addSuppressed((Throwable)err, (Throwable)ex);
                        }
                    }
                    if (err != null) {
                        throw new PaperweightException("Failed to close classpath jars", err);
                    }
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            if (!Files.exists(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((BaseParameters)this.getParameters()).getLog())).getParent(), new LinkOption[0])) {
                Files.createDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((BaseParameters)this.getParameters()).getLog())).getParent(), new FileAttribute[0]);
            }
            object2 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((BaseParameters)this.getParameters()).getLog()));
            object3 = this.log;
            OpenOption[] openOptionArray = new OpenOption[]{};
            object = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)Files.write((Path)object2, (Iterable<? extends CharSequence>)object3, (Charset)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
            if (!((Collection)this.log).isEmpty()) {
                throw new PaperweightException("Bad code was found, see log file at " + FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((BaseParameters)this.getParameters()).getLog())).toAbsolutePath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void scan(FileSystem scan2, ClassNodeCache classNodeCache) {
            AutoCloseable autoCloseable = FileKt.walk(scan2);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                stream.forEach(new Consumer(classNodeCache, this){
                    final /* synthetic */ ClassNodeCache $classNodeCache;
                    final /* synthetic */ ScanJarAction<P> this$0;
                    {
                        this.$classNodeCache = $classNodeCache;
                        this.this$0 = $receiver;
                    }

                    public final void accept(Path file2) {
                        if (!Files.isRegularFile(file2, new LinkOption[0]) || !StringsKt.endsWith$default((String)((Object)file2.getFileName()).toString(), (String)".class", (boolean)false, (int)2, null)) {
                            return;
                        }
                        ClassNode classNode = this.$classNodeCache.findClass(((Object)file2).toString());
                        if (classNode == null) {
                            return;
                        }
                        ClassNode classNode2 = classNode;
                        this.this$0.handleClass(classNode2, this.$classNodeCache);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        protected abstract void handleClass(@NotNull ClassNode var1, @NotNull ClassNodeCache var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/ScanJar$ScanJarAction$BaseParameters;", "Lorg/gradle/workers/WorkParameters;", "jarToScan", "Lorg/gradle/api/file/RegularFileProperty;", "getJarToScan", "()Lorg/gradle/api/file/RegularFileProperty;", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "log", "getLog", "paperweight-lib"})
        public static interface BaseParameters
        extends WorkParameters {
            @NotNull
            public RegularFileProperty getJarToScan();

            @NotNull
            public ConfigurableFileCollection getClasspath();

            @NotNull
            public RegularFileProperty getLog();
        }
    }
}

