/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lio/papermc/paperweight/tasks/ZippedTask;", "Lio/papermc/paperweight/tasks/BaseTask;", "<init>", "()V", "inputZip", "Lorg/gradle/api/file/RegularFileProperty;", "getInputZip", "()Lorg/gradle/api/file/RegularFileProperty;", "outputZip", "getOutputZip", "run", "", "rootDir", "Ljava/nio/file/Path;", "init", "exec", "paperweight-lib"})
public abstract class ZippedTask
extends BaseTask {
    @Optional
    @Classpath
    @NotNull
    public abstract RegularFileProperty getInputZip();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputZip();

    public abstract void run(@NotNull Path var1);

    @Override
    public void init() {
        this.getOutputZip().convention((Provider)UtilsKt.defaultOutput(this, "zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void exec() {
        Path outputZipFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputZip()));
        Path outputDir = UtilsKt.findOutputDir(outputZipFile);
        try {
            Path input = FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getInputZip()));
            if (input != null) {
                v0 = ZipKt.unzip(input, outputDir);
            } else {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path = Files.createDirectories(outputDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                v0 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
            }
            this.run(outputDir);
            Object[] objectArray = new Object[]{outputZipFile};
            UtilsKt.ensureDeleted(objectArray);
            ZipKt.zip(outputDir, outputZipFile);
        }
        finally {
            FileKt.deleteRecursive$default(outputDir, null, null, 3, null);
        }
    }
}

