/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.userdev.internal.setup.BundleInfo;
import io.papermc.paperweight.userdev.internal.setup.v2.DevBundleV2;
import io.papermc.paperweight.userdev.internal.setup.v5.DevBundleV5;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\"\"\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"supported", "", "", "Lkotlin/reflect/KClass;", "", "readBundleInfo", "Lio/papermc/paperweight/userdev/internal/setup/BundleInfo;", "bundleZip", "Ljava/nio/file/Path;", "readDevBundle", "Lkotlin/Pair;", "devBundleRoot", "paperweight-userdev"})
public final class DevBundlesKt {
    @NotNull
    private static final Map<Integer, KClass<? extends Object>> supported;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final BundleInfo<Object> readBundleInfo(@NotNull Path bundleZip) {
        Intrinsics.checkNotNullParameter((Object)bundleZip, (String)"bundleZip");
        AutoCloseable autoCloseable = NioKt.openZipSafe(bundleZip);
        Throwable throwable = null;
        try {
            FileSystemReference fs = (FileSystemReference)autoCloseable;
            boolean bl = false;
            Pair<Object, Integer> pair = DevBundlesKt.readDevBundle(fs.getPath("/"));
            boolean bl2 = false;
            Object config = pair.component1();
            BundleInfo<Object> bundleInfo = new BundleInfo<Object>(config, bundleZip);
            return bundleInfo;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Object, Integer> readDevBundle(Path devBundleRoot) {
        Object t;
        Path path = devBundleRoot.resolve("data-version.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        int dataVersion = Integer.parseInt(((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null))).toString());
        if (!supported.containsKey(dataVersion)) {
            throw new PaperweightException("The paperweight development bundle you are attempting to use is of data version '" + dataVersion + "', but the currently running version of paperweight only supports data versions '" + supported.keySet() + "'.");
        }
        KClass<? extends Object> kClass = supported.get(dataVersion);
        if (kClass == null) {
            throw new PaperweightException("Could not find config class for version " + dataVersion + "?");
        }
        KClass<? extends Object> configClass = kClass;
        Path configFile = devBundleRoot.resolve("config.json");
        Intrinsics.checkNotNull((Object)configFile);
        Object object = configFile;
        Object object2 = Charsets.UTF_8;
        OpenOption[] openOptionArray = new OpenOption[]{};
        int n = 8192;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedReader reader = (BufferedReader)object;
            boolean bl = false;
            Object t2 = UtilsKt.getGson().fromJson((Reader)reader, JvmClassMappingKt.getJavaClass(configClass));
            t = t2;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Intrinsics.checkNotNullExpressionValue(t, (String)"use(...)");
        Object config = t;
        return TuplesKt.to(config, (Object)dataVersion);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)Reflection.getOrCreateKotlinClass(DevBundleV2.Config.class)), TuplesKt.to((Object)3, (Object)Reflection.getOrCreateKotlinClass(DevBundleV5.Config.class)), TuplesKt.to((Object)4, (Object)Reflection.getOrCreateKotlinClass(DevBundleV5.Config.class)), TuplesKt.to((Object)5, (Object)Reflection.getOrCreateKotlinClass(DevBundleV5.Config.class)), TuplesKt.to((Object)6, (Object)Reflection.getOrCreateKotlinClass(GenerateDevBundle.DevBundleConfig.class)), TuplesKt.to((Object)7, (Object)Reflection.getOrCreateKotlinClass(GenerateDevBundle.DevBundleConfig.class))};
        supported = MapsKt.mapOf((Pair[])pairArray);
    }
}

