/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.tasks.JavaLauncherTask;
import io.papermc.paperweight.userdev.internal.setup.SetupHandler;
import io.papermc.paperweight.userdev.internal.setup.UserdevSetup;
import io.papermc.paperweight.userdev.internal.util.UtilsKt;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.workers.WorkerExecutor;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u001d\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0014\u0010\u001f\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0014\u0010#\u001a\u00020$8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020$8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020,8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00062"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetupTask;", "Lio/papermc/paperweight/tasks/JavaLauncherTask;", "<init>", "()V", "setupService", "Lorg/gradle/api/provider/Property;", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup;", "getSetupService", "()Lorg/gradle/api/provider/Property;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "devBundle", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDevBundle", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "decompilerConfig", "getDecompilerConfig", "paramMappingsConfig", "getParamMappingsConfig", "macheDecompilerConfig", "getMacheDecompilerConfig", "macheConfig", "getMacheConfig", "remapperConfig", "getRemapperConfig", "macheRemapperConfig", "getMacheRemapperConfig", "macheParamMappingsConfig", "getMacheParamMappingsConfig", "macheConstantsConfig", "getMacheConstantsConfig", "macheCodebookConfig", "getMacheCodebookConfig", "mappedServerJar", "Lorg/gradle/api/file/RegularFileProperty;", "getMappedServerJar", "()Lorg/gradle/api/file/RegularFileProperty;", "legacyPaperclipResult", "getLegacyPaperclipResult", "reobfMappings", "getReobfMappings", "progressLoggerFactory", "Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;", "getProgressLoggerFactory", "()Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;", "init", "", "run", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nUserdevSetupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserdevSetupTask.kt\nio/papermc/paperweight/userdev/internal/setup/UserdevSetupTask\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,134:1\n45#2,3:135\n45#2,3:138\n*S KotlinDebug\n*F\n+ 1 UserdevSetupTask.kt\nio/papermc/paperweight/userdev/internal/setup/UserdevSetupTask\n*L\n120#1:135,3\n125#1:138,3\n*E\n"})
public abstract class UserdevSetupTask
extends JavaLauncherTask {
    @ServiceReference
    @NotNull
    public abstract Property<UserdevSetup> getSetupService();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getDevBundle();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getDecompilerConfig();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getParamMappingsConfig();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getMacheDecompilerConfig();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getMacheConfig();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getRemapperConfig();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getMacheRemapperConfig();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getMacheParamMappingsConfig();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getMacheConstantsConfig();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getMacheCodebookConfig();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMappedServerJar();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getLegacyPaperclipResult();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getReobfMappings();

    @Inject
    @NotNull
    public abstract ProgressLoggerFactory getProgressLoggerFactory();

    @Override
    public void init() {
        super.init();
        FileKt.set((FileSystemLocationProperty)this.getMappedServerJar(), io.papermc.paperweight.util.UtilsKt.getCache(this.getLayout()).resolve(ConstantsKt.paperTaskOutput("mappedServerJar", "jar")));
        FileKt.set((FileSystemLocationProperty)this.getReobfMappings(), io.papermc.paperweight.util.UtilsKt.getCache(this.getLayout()).resolve(ConstantsKt.paperTaskOutput("reobfMappings", "tiny")));
    }

    @TaskAction
    public final void run() {
        WorkerExecutor workerExecutor = this.getWorkerExecutor();
        Object object = this.getLauncher().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        JavaLauncher javaLauncher = (JavaLauncher)object;
        ProjectLayout projectLayout = this.getLayout();
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        SetupHandler.ExecutionContext context = new SetupHandler.ExecutionContext(workerExecutor, javaLauncher, projectLayout, logger, this.getProgressLoggerFactory(), (FileCollection)this.getDecompilerConfig(), (FileCollection)this.getParamMappingsConfig(), (FileCollection)this.getMacheDecompilerConfig(), (FileCollection)this.getMacheConfig(), (FileCollection)this.getRemapperConfig(), (FileCollection)this.getMacheRemapperConfig(), (FileCollection)this.getMacheParamMappingsConfig(), (FileCollection)this.getMacheConstantsConfig(), (FileCollection)this.getMacheCodebookConfig());
        SetupHandler.ArtifactsResult result2 = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        result2 = ((UserdevSetup)this.getSetupService().get()).generateArtifacts(context);
        long generatedIn = System.nanoTime() - start$iv;
        this.getLogger().lifecycle("Completed setup in " + UtilsKt.formatNs(generatedIn));
        boolean $i$f$measureNanoTime2 = false;
        long start$iv2 = System.nanoTime();
        boolean bl2 = false;
        Path path = result2.getMainOutput();
        Path path2 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMappedServerJar())), (FileAttribute[])new FileAttribute[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path2, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        Path path3 = result2.getLegacyOutput();
        if (path3 != null) {
            path2 = path3;
            Path path4 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getLegacyPaperclipResult())), (FileAttribute[])new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray2;
            Path path5 = Files.copy(path2, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length));
            v7 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"copy(...)");
        } else {
            v7 = null;
        }
        FileKt.deleteForcefully(PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getReobfMappings())), (FileAttribute[])new FileAttribute[0]));
        ((UserdevSetup)this.getSetupService().get()).extractReobfMappings(PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getReobfMappings())), (FileAttribute[])new FileAttribute[0]));
        long copiedTime = System.nanoTime() - start$iv2;
        this.getLogger().lifecycle("Copied artifacts to project cache in " + UtilsKt.formatNs(copiedTime));
    }
}

