/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.HashingAlgorithm;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00b0\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a+\u0010\u0005\u001a\u0002H\u0006\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u0002*\u0002H\u00062\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\u0010\b\u001a \u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u001a \u0010\t\u001a\u00020\r*\u00020\r2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0004\u001a0\u0010\u0012\u001a\u00020\u0001*\u00020\u00042\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0017\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u001e\u001a\n\u0010\u001c\u001a\u00020\u001f*\u00020 \u001a\u0014\u0010!\u001a\u00020\"*\u00020\"2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0012\u0010#\u001a\u00020$*\u00020\u00042\u0006\u0010%\u001a\u00020&\u001a\n\u0010'\u001a\u00020(*\u00020\u0004\u001a\u001c\u0010)\u001a\u00020\u000f*\u00020\u00042\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010+\u001a\u00020,\u001a\u001c\u0010)\u001a\u00020\u000f*\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020,\u001a\u0012\u0010.\u001a\u00020\u0004*\u00020\u00042\u0006\u0010/\u001a\u00020(\u001a\u001e\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0004\u001a\u001e\u00103\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0004\u001a(\u00104\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u000fH\u0002\u001a\f\u0010<\u001a\u00020=*\u00020\u0004H\u0002\u001a\n\u0010>\u001a\u00020?*\u00020\u0004\u001a\n\u0010@\u001a\u00020?*\u00020\u0004\u001a)\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040B*\u00020?2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020E0D\"\u00020E\u00a2\u0006\u0002\u0010F\u001a\u0010\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00040H*\u00020?\u001a\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00040J*\u00020\u00042\b\b\u0002\u0010K\u001a\u00020(\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\"\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u001d\u0010\u0003\u001a\u00020\u0004*\n\u0012\u0006\b\u0001\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\b7\u00109\"\u001f\u0010:\u001a\u0004\u0018\u00010\u0004*\n\u0012\u0006\b\u0001\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\b;\u00109\u00a8\u0006L"}, d2={"set", "", "Lorg/gradle/api/file/FileSystemLocationProperty;", "path", "Ljava/nio/file/Path;", "pathProvider", "P", "Lorg/gradle/api/provider/Provider;", "(Lorg/gradle/api/file/FileSystemLocationProperty;Lorg/gradle/api/provider/Provider;)Lorg/gradle/api/file/FileSystemLocationProperty;", "convention", "Lorg/gradle/api/file/DirectoryProperty;", "project", "Lorg/gradle/api/Project;", "Lorg/gradle/api/file/RegularFileProperty;", "isLibraryJar", "", "(Ljava/nio/file/Path;)Z", "deleteForcefully", "deleteRecursive", "excludes", "", "Ljava/nio/file/PathMatcher;", "preDelete", "Lkotlin/Function1;", "isWindows", "fixWindowsPermissionsForDeletion", "copyRecursivelyTo", "target", "gzip", "Ljava/util/zip/GZIPInputStream;", "Ljava/io/InputStream;", "Ljava/util/zip/GZIPOutputStream;", "Ljava/io/OutputStream;", "directory", "Ljava/lang/ProcessBuilder;", "hashFile", "", "algorithm", "Lio/papermc/paperweight/util/HashingAlgorithm;", "sha256asHex", "", "contentEquals", "two", "bufferSizeBytes", "", "file", "withDifferentExtension", "ext", "relativeCopy", "baseDir", "outputDir", "relativeMove", "relativeCopyOrMove", "move", "Lorg/gradle/api/file/FileSystemLocation;", "getPath", "(Lorg/gradle/api/file/FileSystemLocation;)Ljava/nio/file/Path;", "(Lorg/gradle/api/provider/Provider;)Ljava/nio/file/Path;", "pathOrNull", "getPathOrNull", "jarUri", "Ljava/net/URI;", "openZip", "Ljava/nio/file/FileSystem;", "writeZip", "walkSequence", "Lkotlin/sequences/Sequence;", "options", "", "Lkotlin/io/path/PathWalkOption;", "(Ljava/nio/file/FileSystem;[Lkotlin/io/path/PathWalkOption;)Lkotlin/sequences/Sequence;", "walk", "Ljava/util/stream/Stream;", "filesMatchingRecursive", "", "glob", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 file.kt\nio/papermc/paperweight/util/FileKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1#2:240\n1761#3,3:241\n1869#3,2:244\n1869#3,2:246\n1761#3,3:248\n*S KotlinDebug\n*F\n+ 1 file.kt\nio/papermc/paperweight/util/FileKt\n*L\n75#1:241,3\n88#1:244,2\n89#1:246,2\n85#1:248,3\n*E\n"})
public final class FileKt {
    private static final boolean isWindows;

    public static final void set(@NotNull FileSystemLocationProperty<?> $this$set, @Nullable Path path) {
        Intrinsics.checkNotNullParameter($this$set, (String)"<this>");
        Path path2 = path;
        $this$set.set(path2 != null ? path2.toFile() : null);
    }

    @NotNull
    public static final <P extends FileSystemLocationProperty<?>> P pathProvider(@NotNull P $this$pathProvider, @NotNull Provider<Path> path) {
        P p;
        Intrinsics.checkNotNullParameter($this$pathProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        P $this$pathProvider_u24lambda_u240 = p = $this$pathProvider;
        boolean bl = false;
        $this$pathProvider_u24lambda_u240.fileProvider(path.map((Transformer)pathProvider.1.1.INSTANCE));
        return p;
    }

    @NotNull
    public static final DirectoryProperty convention(@NotNull DirectoryProperty $this$convention, @NotNull Project project, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        DirectoryProperty directoryProperty = $this$convention.convention(project.getLayout().dir(path.map((Transformer)convention.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(...)");
        return directoryProperty;
    }

    @NotNull
    public static final RegularFileProperty convention(@NotNull RegularFileProperty $this$convention, @NotNull Project project, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        RegularFileProperty regularFileProperty = $this$convention.convention(project.getLayout().file(path.map((Transformer)convention.2.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"convention(...)");
        return regularFileProperty;
    }

    @NotNull
    public static final DirectoryProperty convention(@NotNull DirectoryProperty $this$convention, @NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirectoryProperty directoryProperty = $this$convention.convention(project.getLayout().dir(project.provider(new Callable(path){
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
            }

            public final File call() {
                return this.$path.toFile();
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(...)");
        return directoryProperty;
    }

    public static final boolean isLibraryJar(@NotNull Path $this$isLibraryJar) {
        Intrinsics.checkNotNullParameter((Object)$this$isLibraryJar, (String)"<this>");
        return StringsKt.endsWith$default((String)PathsKt.getName((Path)$this$isLibraryJar), (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)PathsKt.getName((Path)$this$isLibraryJar), (String)"-sources.jar", (boolean)false, (int)2, null);
    }

    public static final void deleteForcefully(@NotNull Path $this$deleteForcefully) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteForcefully, (String)"<this>");
        FileKt.fixWindowsPermissionsForDeletion($this$deleteForcefully);
        Files.deleteIfExists($this$deleteForcefully);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteRecursive(@NotNull Path $this$deleteRecursive, @NotNull Iterable<? extends PathMatcher> excludes, @NotNull Function1<? super Path, Unit> preDelete) {
        Path f;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter(preDelete, (String)"preDelete");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$deleteRecursive, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory($this$deleteRecursive, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            boolean bl;
            block14: {
                Iterable<? extends PathMatcher> $this$any$iv = excludes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator<? extends PathMatcher> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        PathMatcher element$iv;
                        PathMatcher it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!it.matches($this$deleteRecursive)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            preDelete.invoke((Object)$this$deleteRecursive);
            FileKt.fixWindowsPermissionsForDeletion($this$deleteRecursive);
            Files.deleteIfExists($this$deleteRecursive);
            return;
        }
        AutoCloseable $i$f$any = Files.walk($this$deleteRecursive, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)$i$f$any;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            iterator = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)StreamsKt.asSequence((Stream)stream), arg_0 -> FileKt.deleteRecursive$lambda$5$lambda$4(excludes, arg_0)));
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$any, (Throwable)throwable);
        }
        List fileList = iterator;
        Iterable $this$forEach$iv = fileList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            f = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)f);
            FileKt.fixWindowsPermissionsForDeletion(f);
        }
        $this$forEach$iv = CollectionsKt.asReversed((List)fileList);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            f = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)f);
            preDelete.invoke((Object)f);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isRegularFile(f, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                Files.deleteIfExists(f);
                continue;
            }
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (!Files.isDirectory(f, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) || !PathsKt.listDirectoryEntries$default((Path)f, null, (int)1, null).isEmpty()) continue;
            Files.deleteIfExists(f);
        }
    }

    public static /* synthetic */ void deleteRecursive$default(Path path, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            function1 = FileKt::deleteRecursive$lambda$1;
        }
        FileKt.deleteRecursive(path, iterable, (Function1<? super Path, Unit>)function1);
    }

    private static final void fixWindowsPermissionsForDeletion(Path $this$fixWindowsPermissionsForDeletion) {
        block7: {
            block6: {
                if (!isWindows) break block6;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.notExists($this$fixWindowsPermissionsForDeletion, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block7;
            }
            return;
        }
        Path path = $this$fixWindowsPermissionsForDeletion;
        try {
            Path $this$fixWindowsPermissionsForDeletion_u24lambda_u248 = path;
            boolean bl = false;
            Path path2 = $this$fixWindowsPermissionsForDeletion_u24lambda_u248;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path2, DosFileAttributeView.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (dosFileAttributeView == null) {
                PathsKt.fileAttributeViewNotAvailable((Path)path2, DosFileAttributeView.class);
                throw new KotlinNothingValueException();
            }
            DosFileAttributeView dosAttr = dosFileAttributeView;
            dosAttr.setHidden(false);
            dosAttr.setReadOnly(false);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyRecursivelyTo(@NotNull Path $this$copyRecursivelyTo, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursivelyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(target, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$copyRecursivelyTo, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        AutoCloseable autoCloseable = Files.walk($this$copyRecursivelyTo, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path path;
                Path f = (Path)iterator.next();
                Intrinsics.checkNotNull((Object)f);
                Path targetPath = target.resolve(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)f, (Path)$this$copyRecursivelyTo)));
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(f, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Intrinsics.checkNotNull((Object)targetPath);
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                    Path path2 = Files.createDirectories(targetPath, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
                    path = path2;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
                    continue;
                }
                Path path3 = f;
                Intrinsics.checkNotNull((Object)targetPath);
                Path path4 = targetPath;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Path path5 = Files.copy(path3, path4, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                path = path5;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"copy(...)");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final GZIPInputStream gzip(@NotNull InputStream $this$gzip) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        return new GZIPInputStream($this$gzip);
    }

    @NotNull
    public static final GZIPOutputStream gzip(@NotNull OutputStream $this$gzip) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        return new GZIPOutputStream($this$gzip);
    }

    @NotNull
    public static final ProcessBuilder directory(@NotNull ProcessBuilder $this$directory, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"<this>");
        Path path2 = path;
        ProcessBuilder processBuilder = $this$directory.directory(path2 != null ? path2.toFile() : null);
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"directory(...)");
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] hashFile(@NotNull Path $this$hashFile, @NotNull HashingAlgorithm algorithm) {
        byte[] byArray2;
        Intrinsics.checkNotNullParameter((Object)$this$hashFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$hashFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            byArray2 = UtilsKt.hash$default(input, algorithm, 0, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray2;
    }

    @NotNull
    public static final String sha256asHex(@NotNull Path $this$sha256asHex) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256asHex, (String)"<this>");
        return UtilsKt.asHexString(FileKt.hashFile($this$sha256asHex, HashingAlgorithm.SHA256));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean contentEquals(@NotNull Path $this$contentEquals, @NotNull InputStream two, int bufferSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$contentEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)two, (String)"two");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$contentEquals, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            block9: {
                int readOne;
                InputStream one = (InputStream)closeable;
                boolean bl = false;
                byte[] bufOne = new byte[bufferSizeBytes];
                byte[] bufTwo = new byte[bufferSizeBytes];
                do {
                    int readTwo;
                    if ((readOne = one.read(bufOne)) != (readTwo = two.read(bufTwo))) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (readOne == -1) break block9;
                } while (Arrays.equals(bufOne, 0, readOne, bufTwo, 0, readOne));
                boolean bl3 = false;
                return bl3;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    public static /* synthetic */ boolean contentEquals$default(Path path, InputStream inputStream, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return FileKt.contentEquals(path, inputStream, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean contentEquals(@NotNull Path $this$contentEquals, @NotNull Path file2, int bufferSizeBytes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$contentEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file2, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream two = (InputStream)closeable;
            boolean bl2 = false;
            bl = FileKt.contentEquals($this$contentEquals, two, bufferSizeBytes);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    public static /* synthetic */ boolean contentEquals$default(Path path, Path path2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return FileKt.contentEquals(path, path2, n);
    }

    @NotNull
    public static final Path withDifferentExtension(@NotNull Path $this$withDifferentExtension, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)$this$withDifferentExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Path path = $this$withDifferentExtension.resolveSibling(PathsKt.getNameWithoutExtension((Path)$this$withDifferentExtension) + "." + ext);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    public static final void relativeCopy(@NotNull Path baseDir, @NotNull Path file2, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        FileKt.relativeCopyOrMove(baseDir, file2, outputDir, false);
    }

    public static final void relativeMove(@NotNull Path baseDir, @NotNull Path file2, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        FileKt.relativeCopyOrMove(baseDir, file2, outputDir, true);
    }

    private static final void relativeCopyOrMove(Path baseDir, Path file2, Path outputDir, boolean move) {
        Path destination = outputDir.resolve(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)file2, (Path)baseDir)));
        Path path = destination.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        if (move) {
            path2 = file2;
            Intrinsics.checkNotNull((Object)destination);
            object = destination;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Path path3 = Files.move(path2, (Path)object, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
            v2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"move(...)");
        } else {
            path2 = file2;
            Intrinsics.checkNotNull((Object)destination);
            object = destination;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray;
            Path path4 = Files.copy(path2, (Path)object, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length));
            v2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"copy(...)");
        }
    }

    @NotNull
    public static final Path getPath(@NotNull FileSystemLocation $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        Path path = $this$path.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public static final Path getPath(@NotNull Provider<? extends FileSystemLocation> $this$path) {
        Intrinsics.checkNotNullParameter($this$path, (String)"<this>");
        Object object = $this$path.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return FileKt.getPath((FileSystemLocation)object);
    }

    @Nullable
    public static final Path getPathOrNull(@NotNull Provider<? extends FileSystemLocation> $this$pathOrNull) {
        Intrinsics.checkNotNullParameter($this$pathOrNull, (String)"<this>");
        FileSystemLocation fileSystemLocation = (FileSystemLocation)$this$pathOrNull.getOrNull();
        return fileSystemLocation != null ? FileKt.getPath(fileSystemLocation) : null;
    }

    private static final URI jarUri(Path $this$jarUri) {
        URI uRI = URI.create("jar:" + $this$jarUri.toUri());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    @NotNull
    public static final FileSystem openZip(@NotNull Path $this$openZip) {
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter((Object)$this$openZip, (String)"<this>");
        try {
            fileSystem = FileSystems.getFileSystem(FileKt.jarUri($this$openZip));
            Intrinsics.checkNotNull((Object)fileSystem);
        }
        catch (FileSystemNotFoundException e) {
            FileSystem fileSystem2 = FileSystems.newFileSystem(FileKt.jarUri($this$openZip), MapsKt.emptyMap());
            Intrinsics.checkNotNull((Object)fileSystem2);
            fileSystem = fileSystem2;
        }
        return fileSystem;
    }

    @NotNull
    public static final FileSystem writeZip(@NotNull Path $this$writeZip) {
        Intrinsics.checkNotNullParameter((Object)$this$writeZip, (String)"<this>");
        FileSystem fileSystem = FileSystems.newFileSystem(FileKt.jarUri($this$writeZip), MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"true")));
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(...)");
        return fileSystem;
    }

    @NotNull
    public static final Sequence<Path> walkSequence(@NotNull FileSystem $this$walkSequence, PathWalkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)$this$walkSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Stream<Path> stream = StreamSupport.stream($this$walkSequence.getRootDirectories().spliterator(), false);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return SequencesKt.flatMap((Sequence)StreamsKt.asSequence(stream), arg_0 -> FileKt.walkSequence$lambda$13(options, arg_0));
    }

    @NotNull
    public static final Stream<Path> walk(@NotNull FileSystem $this$walk) {
        Intrinsics.checkNotNullParameter((Object)$this$walk, (String)"<this>");
        Stream<Path> stream = StreamSupport.stream($this$walk.getRootDirectories().spliterator(), false).flatMap(walk.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> filesMatchingRecursive(@NotNull Path $this$filesMatchingRecursive, @NotNull String glob) {
        List<Path> list;
        Intrinsics.checkNotNullParameter((Object)$this$filesMatchingRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$filesMatchingRecursive, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        PathMatcher matcher = $this$filesMatchingRecursive.getFileSystem().getPathMatcher("glob:" + glob);
        AutoCloseable autoCloseable = Files.walk($this$filesMatchingRecursive, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            List<Path> list2 = stream.filter(new Predicate(matcher){
                final /* synthetic */ PathMatcher $matcher;
                {
                    this.$matcher = $matcher;
                }

                public final boolean test(Path it) {
                    Intrinsics.checkNotNull((Object)it);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && this.$matcher.matches(it.getFileName());
                }
            }).collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"use(...)");
        return list;
    }

    public static /* synthetic */ List filesMatchingRecursive$default(Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "*";
        }
        return FileKt.filesMatchingRecursive(path, string);
    }

    private static final Unit deleteRecursive$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final boolean deleteRecursive$lambda$5$lambda$4(Iterable $excludes, Path file2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $excludes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PathMatcher it = (PathMatcher)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(file2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Sequence walkSequence$lambda$13(PathWalkOption[] $options, Path it) {
        Intrinsics.checkNotNull((Object)it);
        return PathsKt.walk((Path)it, (PathWalkOption[])Arrays.copyOf($options, $options.length));
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        isWindows = StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true);
    }
}

