/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.NioKt;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathWalkOption;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0015H\u0016J'\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lio/papermc/paperweight/util/FileSystemReferenceImpl;", "Lio/papermc/paperweight/util/FileSystemReference;", "path", "Ljava/nio/file/Path;", "reference", "Ljava/nio/file/FileSystem;", "openers", "", "closed", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/FileSystem;IZ)V", "getOpeners", "()I", "setOpeners", "(I)V", "getClosed", "()Z", "setClosed", "(Z)V", "getPath", "", "walkSequence", "Lkotlin/sequences/Sequence;", "options", "", "Lkotlin/io/path/PathWalkOption;", "([Lkotlin/io/path/PathWalkOption;)Lkotlin/sequences/Sequence;", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "matcher", "close", "", "paperweight-lib"})
final class FileSystemReferenceImpl
implements FileSystemReference {
    @NotNull
    private final Path path;
    @NotNull
    private final FileSystem reference;
    private volatile int openers;
    private volatile boolean closed;

    public FileSystemReferenceImpl(@NotNull Path path, @NotNull FileSystem reference2, int openers, boolean closed) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        this.path = path;
        this.reference = reference2;
        this.openers = openers;
        this.closed = closed;
    }

    public /* synthetic */ FileSystemReferenceImpl(Path path, FileSystem fileSystem, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(path, fileSystem, n, bl);
    }

    public final int getOpeners() {
        return this.openers;
    }

    public final void setOpeners(int n) {
        this.openers = n;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = this.reference.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
        return path2;
    }

    @Override
    @NotNull
    public Sequence<Path> walkSequence(PathWalkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return FileKt.walkSequence(this.reference, new PathWalkOption[0]);
    }

    @Override
    @NotNull
    public PathMatcher getPathMatcher(@NotNull String matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        PathMatcher pathMatcher = this.reference.getPathMatcher(matcher);
        Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getPathMatcher(...)");
        return pathMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FileSystemReferenceImpl fileSystemReferenceImpl = this;
        synchronized (fileSystemReferenceImpl) {
            boolean bl = false;
            int n = this.openers;
            this.openers = n + -1;
            if (this.openers == 0) {
                try {
                    this.reference.close();
                }
                finally {
                    this.closed = true;
                    NioKt.access$getOpenJars$p().remove(this.path);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

