/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.util.archiver;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import paper.libs.codechicken.diffpatch.util.Utils;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveReader;
import paper.libs.codechicken.repack.net.covers1624.quack.io.IOUtils;
import paper.libs.codechicken.repack.org.apache.commons.compress.archivers.ArchiveEntry;
import paper.libs.codechicken.repack.org.apache.commons.compress.archivers.ArchiveInputStream;

public class ArchiveInputStreamReader
implements ArchiveReader {
    private final Map<String, byte[]> archiveIndex = new LinkedHashMap<String, byte[]>();
    private final ArchiveInputStream is;

    public ArchiveInputStreamReader(ArchiveInputStream is, String prefix) {
        this.is = is;
        try {
            ArchiveEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name2 = Utils.stripStart('/', entry.getName());
                if (!prefix.isEmpty() && !entry.getName().startsWith(prefix)) continue;
                this.archiveIndex.put(Utils.stripStart('/', name2.substring(prefix.length())), IOUtils.toBytes(is));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to index archive", e);
        }
    }

    @Override
    public Set<String> getEntries() {
        return Collections.unmodifiableSet(this.archiveIndex.keySet());
    }

    @Override
    public byte[] getBytes(String entry) {
        return this.archiveIndex.get(entry);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

