/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints;

import java.util.AbstractCollection;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.IntCollection;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.IntIterator;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.IntIterators;

public abstract class AbstractIntCollection
extends AbstractCollection<Integer>
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public abstract IntIterator iterator();

    @Override
    public boolean add(int k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(int k) {
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k != iterator.nextInt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(int k) {
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k != iterator.nextInt()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Integer key) {
        return IntCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return IntCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return IntCollection.super.remove(key);
    }

    @Override
    public int[] toArray(int[] a) {
        if (a == null || a.length < this.size()) {
            a = new int[this.size()];
        }
        IntIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    public int[] toIntArray() {
        return this.toArray((int[])null);
    }

    @Override
    @Deprecated
    public int[] toIntArray(int[] a) {
        return this.toArray(a);
    }

    @Override
    public boolean addAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean containsAll(IntCollection c) {
        IntIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextInt())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        IntIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            int k = i2.nextInt();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

