/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm;

import paper.libs.dev.denwav.hypo.asm.HypoAsmUtil;
import paper.libs.dev.denwav.hypo.model.data.AbstractFieldData;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.Type;
import paper.libs.org.objectweb.asm.tree.FieldNode;

public class AsmFieldData
extends AbstractFieldData
implements FieldData {
    @NotNull
    private final ClassData parentClass;
    @NotNull
    private final FieldNode node;

    public AsmFieldData(@NotNull ClassData parentClass, @NotNull FieldNode node) {
        this.parentClass = parentClass;
        this.node = node;
    }

    @NotNull
    public FieldNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public JvmType fieldType() {
        return HypoAsmUtil.toJvmType(Type.getType(this.node.desc));
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return HypoAsmUtil.accessToVisibility(this.node.access);
    }

    @Override
    public boolean isStatic() {
        return (this.node.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.node.access & 0x10) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.node.access & 0x1000) != 0;
    }

    @Override
    @NotNull
    public String name() {
        return this.node.name;
    }

    @Override
    @NotNull
    public ClassData parentClass() {
        return this.parentClass;
    }
}

