/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.lang.reflect.Field;
import java.util.Map;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtilHelper;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.impl.MappingSetImpl;
import paper.libs.org.cadixdev.lorenz.impl.model.AbstractClassMappingImpl;
import paper.libs.org.cadixdev.lorenz.impl.model.MethodMappingImpl;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.InnerClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;
import paper.libs.org.cadixdev.lorenz.model.TopLevelClassMapping;
import paper.libs.org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

final class LorenzUtilHelperJdk8
extends LorenzUtilHelper {
    @NotNull
    private static final Unsafe unsafe;
    private static final long topLevelClassesOffset;
    private static final long innerClassesOffset;
    private static final long fieldsOffset;
    private static final long fieldsByNameOffset;
    private static final long methodsOffset;
    private static final long paramsOffset;

    LorenzUtilHelperJdk8() {
    }

    @Override
    @NotNull
    Map<String, TopLevelClassMapping> getTopLevelClassesMap(@NotNull MappingSet mappingSet) {
        MappingSetImpl castMap = LorenzUtil.checkType(mappingSet);
        Object unsafeResult = unsafe.getObject(castMap, topLevelClassesOffset);
        Map result2 = (Map)HypoModelUtil.cast(unsafeResult);
        return LorenzUtil.notNull(result2, "topLevelClasses");
    }

    @Override
    @NotNull
    final Map<String, InnerClassMapping> getInnerClassesMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object unsafeResult = unsafe.getObject(castMap, innerClassesOffset);
        Map result2 = (Map)HypoModelUtil.cast(unsafeResult);
        return LorenzUtil.notNull(result2, "innerClasses");
    }

    @Override
    @NotNull
    Map<FieldSignature, FieldMapping> getFieldsMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object unsafeResult = unsafe.getObject(castMap, fieldsOffset);
        Map result2 = (Map)HypoModelUtil.cast(unsafeResult);
        return LorenzUtil.notNull(result2, "fields");
    }

    @Override
    @NotNull
    Map<String, FieldMapping> getFieldsByNameMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object unsafeResult = unsafe.getObject(castMap, fieldsByNameOffset);
        Map result2 = (Map)HypoModelUtil.cast(unsafeResult);
        return LorenzUtil.notNull(result2, "fieldsByName");
    }

    @Override
    @NotNull
    Map<MethodSignature, MethodMapping> getMethodsMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object unsafeResult = unsafe.getObject(castMap, methodsOffset);
        Map result2 = (Map)HypoModelUtil.cast(unsafeResult);
        return LorenzUtil.notNull(result2, "methods");
    }

    @Override
    @NotNull
    Map<Integer, MethodParameterMapping> getParamsMap(@NotNull MethodMapping mapping) {
        MethodMappingImpl castMap = LorenzUtil.checkType(mapping);
        Object unsafeResult = unsafe.getObject(castMap, paramsOffset);
        Map result2 = (Map)HypoModelUtil.cast(unsafeResult);
        return LorenzUtil.notNull(result2, "parameters");
    }

    static {
        try {
            Field theUnsafe = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
            topLevelClassesOffset = unsafe.objectFieldOffset(MappingSetImpl.class.getDeclaredField("topLevelClasses"));
            innerClassesOffset = unsafe.objectFieldOffset(AbstractClassMappingImpl.class.getDeclaredField("innerClasses"));
            fieldsOffset = unsafe.objectFieldOffset(AbstractClassMappingImpl.class.getDeclaredField("fields"));
            fieldsByNameOffset = unsafe.objectFieldOffset(AbstractClassMappingImpl.class.getDeclaredField("fieldsByName"));
            methodsOffset = unsafe.objectFieldOffset(AbstractClassMappingImpl.class.getDeclaredField("methods"));
            paramsOffset = unsafe.objectFieldOffset(MethodMappingImpl.class.getDeclaredField("parameters"));
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }
}

