/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.changes;

import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.MergeResult;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;

public class RemoveMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<RemoveMappingChange> {
    private RemoveMappingChange(@NotNull MemberReference target) {
        super(target);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static RemoveMappingChange of(@NotNull MemberReference target) {
        return new RemoveMappingChange(target);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        ClassMapping<?, ?> map2 = LorenzUtil.getClassMapping(input, target.className());
        if (map2 == null) {
            return;
        }
        String desc = target.desc();
        if (desc != null && desc.startsWith("(")) {
            MethodMapping methodMap = LorenzUtil.getMethodMapping(map2, target.name(), desc);
            if (methodMap != null) {
                LorenzUtil.removeMethodMapping(methodMap);
            }
        } else {
            FieldMapping fieldMap = desc == null ? LorenzUtil.getFieldMapping(map2, target.name()) : LorenzUtil.getFieldMapping(map2, FieldSignature.of(target.name(), desc));
            if (fieldMap != null) {
                LorenzUtil.removeFieldMapping(fieldMap);
            }
        }
        if (!map2.hasMappings()) {
            LorenzUtil.removeClassMapping(map2);
        }
    }

    @Override
    @NotNull
    public MergeResult<RemoveMappingChange> mergeWith(@NotNull RemoveMappingChange that) {
        return MergeResult.success(this);
    }

    public String toString() {
        return "Remove " + this.target();
    }
}

