/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.net.fabricmc.lorenztiny;

import java.io.Writer;
import java.util.Comparator;
import paper.libs.net.fabricmc.lorenztiny.AbstractTinyMappingsWriter;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.Mapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;

public class TinyMappingsWriter
extends AbstractTinyMappingsWriter {
    public TinyMappingsWriter(Writer writer, String from, String to) {
        super(writer, from, to);
    }

    @Override
    public void write(MappingSet mappings) {
        this.writeHeaderLine();
        mappings.getTopLevelClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
    }

    private void writeClassMapping(ClassMapping<?, ?> mapping) {
        this.writer.print("c\t");
        this.writer.print(mapping.getFullObfuscatedName());
        this.writer.print('\t');
        this.writer.println(mapping.getFullDeobfuscatedName());
        mapping.getMethodMappings().stream().filter(MethodMapping::hasMappings).sorted(this.getConfig().getMethodMappingComparator()).forEach(this::writeMethodMapping);
        mapping.getFieldMappings().stream().filter(Mapping::hasDeobfuscatedName).sorted(this.getConfig().getFieldMappingComparator()).forEach(this::writeFieldMapping);
        mapping.getInnerClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
    }

    private void writeMethodMapping(MethodMapping mapping) {
        this.writer.print("\tm\t");
        this.writer.print(mapping.getObfuscatedDescriptor());
        this.writer.print('\t');
        this.writer.print(mapping.getObfuscatedName());
        this.writer.print('\t');
        this.writer.println(mapping.getDeobfuscatedName());
        mapping.getParameterMappings().stream().filter(Mapping::hasDeobfuscatedName).sorted(Comparator.comparingInt(MethodParameterMapping::getIndex)).forEach(this::writeParamMapping);
    }

    private void writeParamMapping(MethodParameterMapping mapping) {
        this.writer.print("\t\tp\t");
        this.writer.print(mapping.getIndex());
        this.writer.print("\t\t");
        this.writer.println(mapping.getDeobfuscatedName());
    }

    private void writeFieldMapping(FieldMapping mapping) {
        this.writer.print("\tf\t");
        this.writer.print(this.requireType(mapping));
        this.writer.print('\t');
        this.writer.print(mapping.getObfuscatedName());
        this.writer.print('\t');
        this.writer.println(mapping.getDeobfuscatedName());
    }

    private void writeHeaderLine() {
        this.writer.print("tiny\t2\t0\t");
        this.writer.print(this.from);
        this.writer.print('\t');
        this.writer.print(this.to);
        this.writer.println();
    }
}

