/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.http.impl.conn;

import paper.libs.org.apache.http.HttpResponse;
import paper.libs.org.apache.http.HttpResponseFactory;
import paper.libs.org.apache.http.annotation.Contract;
import paper.libs.org.apache.http.annotation.ThreadingBehavior;
import paper.libs.org.apache.http.config.MessageConstraints;
import paper.libs.org.apache.http.impl.DefaultHttpResponseFactory;
import paper.libs.org.apache.http.impl.conn.DefaultHttpResponseParser;
import paper.libs.org.apache.http.io.HttpMessageParser;
import paper.libs.org.apache.http.io.HttpMessageParserFactory;
import paper.libs.org.apache.http.io.SessionInputBuffer;
import paper.libs.org.apache.http.message.BasicLineParser;
import paper.libs.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

