/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.jar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServiceProviderConfiguration {
    private final String service;
    private final List<String> providers;

    public ServiceProviderConfiguration(String service, List<String> providers) {
        this.service = service;
        this.providers = providers;
    }

    public ServiceProviderConfiguration(String service) {
        this(service, new ArrayList<String>());
    }

    public final String getService() {
        return this.service;
    }

    public final List<String> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public final void addProvider(String provider) {
        this.providers.add(provider);
    }

    public void read(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            reader.lines().map(provider -> {
                int commentStart = provider.indexOf(35);
                if (commentStart == -1) {
                    return provider;
                }
                return provider.substring(0, commentStart);
            }).map(String::trim).filter(provider -> !provider.isEmpty()).forEach(this.providers::add);
        }
    }

    public void write(OutputStream os) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));){
            for (String provider : this.providers) {
                writer.write(provider);
                writer.newLine();
            }
        }
    }
}

