/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.type.reference;

import java.util.Objects;
import java.util.StringJoiner;
import paper.libs.org.cadixdev.bombe.type.reference.MethodReference;
import paper.libs.org.cadixdev.bombe.type.reference.QualifiedReference;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;

public class MethodParameterReference
extends QualifiedReference {
    private final MethodReference parentMethod;
    private final int index;

    public MethodParameterReference(MethodReference parentMethod, int index) throws IllegalArgumentException {
        super(QualifiedReference.Type.METHOD_PARAMETER);
        if (index >= ((MethodSignature)parentMethod.getSignature()).getDescriptor().getParamTypes().size()) {
            throw new IllegalArgumentException("Cannot get out-of-bounds parameter index " + index);
        }
        this.parentMethod = parentMethod;
        this.index = index;
    }

    public MethodReference getParentMethod() {
        return this.parentMethod;
    }

    public int getParameterIndex() {
        return this.index;
    }

    @Override
    public String toJvmsIdentifier() {
        return this.getParentMethod().toJvmsIdentifier() + '.' + this.index;
    }

    @Override
    public StringJoiner buildToString() {
        return super.buildToString().add(";parentMethod=" + this.parentMethod.toJvmsIdentifier()).add(";index=" + this.index);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodParameterReference)) {
            return false;
        }
        MethodParameterReference that = (MethodParameterReference)obj;
        return super.equals(obj) && Objects.equals(this.parentMethod, that.parentMethod) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentMethod, this.index);
    }
}

