/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.type.signature;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.bombe.type.signature.MemberSignature;

public class FieldSignature
extends MemberSignature {
    private final FieldType type;

    public static FieldSignature of(String name2, String type) {
        return new FieldSignature(name2, FieldType.of(type));
    }

    public static FieldSignature of(Field field) {
        return new FieldSignature(field.getName(), FieldType.of(field.getType()));
    }

    public FieldSignature(String name2, FieldType type) {
        super(name2);
        this.type = type;
    }

    public FieldSignature(String name2) {
        this(name2, null);
    }

    public Optional<FieldType> getType() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public String toJvmsIdentifier() {
        return this.name + "(" + this.type.toString() + ")";
    }

    @Override
    protected StringJoiner buildToString() {
        return super.buildToString().add("type=" + this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldSignature)) {
            return false;
        }
        FieldSignature that = (FieldSignature)obj;
        if (this.type != null && that.type != null) {
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }
}

