/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.io.srg.csrg;

import java.io.Reader;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.io.TextMappingsReader;
import paper.libs.org.cadixdev.lorenz.io.srg.SrgConstants;

public class CSrgReader
extends TextMappingsReader {
    public CSrgReader(Reader reader) {
        super(reader, Processor::new);
    }

    public static class Processor
    extends TextMappingsReader.Processor {
        private static final int CLASS_MAPPING_ELEMENT_COUNT = 2;
        private static final int FIELD_MAPPING_ELEMENT_COUNT = 3;
        private static final int METHOD_MAPPING_ELEMENT_COUNT = 4;

        public Processor(MappingSet mappings) {
            super(mappings);
        }

        public Processor() {
            this(MappingSet.create());
        }

        @Override
        public void accept(String rawLine) {
            String line = SrgConstants.removeComments(rawLine).trim();
            if (line.isEmpty()) {
                return;
            }
            if (line.length() < 4) {
                throw new IllegalArgumentException("Faulty CSRG mapping encountered: `" + line + "`!");
            }
            String[] split = SPACE.split(line);
            int len = split.length;
            if (len == 2) {
                String obfuscatedName = split[0];
                String deobfuscatedName = split[1];
                if (!obfuscatedName.endsWith("/")) {
                    this.mappings.getOrCreateClassMapping(obfuscatedName).setDeobfuscatedName(deobfuscatedName);
                }
            } else if (len == 3) {
                String parentClass = split[0];
                String obfuscatedName = split[1];
                String deobfuscatedName = split[2];
                this.mappings.getOrCreateClassMapping(parentClass).getOrCreateFieldMapping(obfuscatedName).setDeobfuscatedName(deobfuscatedName);
            } else if (len == 4) {
                String parentClass = split[0];
                String obfuscatedName = split[1];
                String obfuscatedSignature = split[2];
                String deobfuscatedName = split[3];
                this.mappings.getOrCreateClassMapping(parentClass).getOrCreateMethodMapping(obfuscatedName, obfuscatedSignature).setDeobfuscatedName(deobfuscatedName);
            } else {
                throw new IllegalArgumentException("Failed to process line: `" + line + "`!");
            }
        }
    }
}

