/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.spanning;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.Graphs;
import paper.libs.org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import paper.libs.org.jgrapht.util.CollectionUtil;
import paper.libs.org.jgrapht.util.VertexToIntegerMapping;
import paper.libs.org.jheaps.AddressableHeap;
import paper.libs.org.jheaps.tree.FibonacciHeap;

public class PrimMinimumSpanningTree<V, E>
implements SpanningTreeAlgorithm<E> {
    private final Graph<V, E> g;

    public PrimMinimumSpanningTree(Graph<V, E> graph) {
        this.g = Objects.requireNonNull(graph, "Graph cannot be null");
    }

    @Override
    public SpanningTreeAlgorithm.SpanningTree<E> getSpanningTree() {
        HashSet minimumSpanningTreeEdgeSet = CollectionUtil.newHashSetWithExpectedSize(this.g.vertexSet().size());
        double spanningTreeWeight = 0.0;
        int N = this.g.vertexSet().size();
        VertexToIntegerMapping<V> vertexToIntegerMapping = Graphs.getVertexToIntegerMapping(this.g);
        Map<V, Integer> vertexMap = vertexToIntegerMapping.getVertexMap();
        List<V> indexList = vertexToIntegerMapping.getIndexList();
        VertexInfo[] vertices = (VertexInfo[])Array.newInstance(VertexInfo.class, N);
        AddressableHeap.Handle[] fibNodes = (AddressableHeap.Handle[])Array.newInstance(AddressableHeap.Handle.class, N);
        FibonacciHeap<Double, VertexInfo> fibonacciHeap = new FibonacciHeap<Double, VertexInfo>();
        for (int i2 = 0; i2 < N; ++i2) {
            vertices[i2] = new VertexInfo();
            vertices[i2].id = i2;
            vertices[i2].distance = Double.MAX_VALUE;
            fibNodes[i2] = fibonacciHeap.insert(vertices[i2].distance, vertices[i2]);
        }
        while (!fibonacciHeap.isEmpty()) {
            AddressableHeap.Handle fibNode = fibonacciHeap.deleteMin();
            VertexInfo vertexInfo = (VertexInfo)fibNode.getValue();
            V p = indexList.get(vertexInfo.id);
            vertexInfo.spanned = true;
            if (vertexInfo.edgeFromParent != null) {
                minimumSpanningTreeEdgeSet.add(vertexInfo.edgeFromParent);
                spanningTreeWeight += this.g.getEdgeWeight(vertexInfo.edgeFromParent);
            }
            for (E e : this.g.edgesOf(p)) {
                double cost;
                V q = Graphs.getOppositeVertex(this.g, e, p);
                int id = vertexMap.get(q);
                if (vertices[id].spanned || !((cost = this.g.getEdgeWeight(e)) < vertices[id].distance)) continue;
                vertices[id].distance = cost;
                vertices[id].edgeFromParent = e;
                fibNodes[id].decreaseKey(cost);
            }
        }
        return new SpanningTreeAlgorithm.SpanningTreeImpl(minimumSpanningTreeEdgeSet, spanningTreeWeight);
    }

    private class VertexInfo {
        public int id;
        public boolean spanned;
        public double distance;
        public E edgeFromParent;

        private VertexInfo() {
        }
    }
}

