/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.tour;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphPath;
import paper.libs.org.jgrapht.alg.tour.HamiltonianCycleAlgorithmBase;
import paper.libs.org.jgrapht.alg.util.UnionFind;

public class GreedyHeuristicTSP<V, E>
extends HamiltonianCycleAlgorithmBase<V, E> {
    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        this.checkGraph(graph);
        int n = graph.vertexSet().size();
        if (n == 1) {
            return this.getSingletonTour(graph);
        }
        Deque edges = graph.edgeSet().stream().sorted((e1, e2) -> Double.compare(graph.getEdgeWeight(e1), graph.getEdgeWeight(e2))).collect(Collectors.toCollection(() -> new ArrayDeque()));
        HashSet tourEdges = new HashSet(n);
        Map<Object, Integer> vertexDegree = graph.vertexSet().stream().collect(Collectors.toMap(v -> v, v -> 0));
        UnionFind<V> tourSet = new UnionFind<V>(graph.vertexSet());
        while (!edges.isEmpty() && tourEdges.size() < n) {
            V vertex2;
            Object edge = edges.pollFirst();
            V vertex1 = graph.getEdgeSource(edge);
            if (!this.canAddEdge(vertexDegree, tourSet, vertex1, vertex2 = graph.getEdgeTarget(edge), tourEdges.size() == n - 1)) continue;
            tourEdges.add(edge);
            vertexDegree.put(vertex1, vertexDegree.get(vertex1) + 1);
            vertexDegree.put(vertex2, vertexDegree.get(vertex2) + 1);
            tourSet.union(vertex1, vertex2);
        }
        return this.edgeSetToTour(tourEdges, graph);
    }

    private boolean canAddEdge(Map<V, Integer> vertexDegree, UnionFind<V> tourSet, V vertex1, V vertex2, boolean lastEdge) {
        if (vertexDegree.get(vertex1) > 1 || vertexDegree.get(vertex2) > 1) {
            return false;
        }
        return tourSet.inSameSet(vertex1, vertex2) ? lastEdge : !lastEdge;
    }
}

