/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphPath;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.alg.interfaces.HamiltonianCycleAlgorithm;
import paper.libs.org.jgrapht.graph.GraphWalk;
import paper.libs.org.jgrapht.graph.MaskSubgraph;
import paper.libs.org.jgrapht.traverse.DepthFirstIterator;

public abstract class HamiltonianCycleAlgorithmBase<V, E>
implements HamiltonianCycleAlgorithm<V, E> {
    protected GraphPath<V, E> vertexListToTour(List<V> tour, Graph<V, E> graph) {
        V first2;
        ArrayList<E> edges = new ArrayList<E>(tour.size() + 1);
        double tourWeight = 0.0;
        Iterator<V> tourIterator = tour.iterator();
        V u = first2 = tourIterator.next();
        while (tourIterator.hasNext()) {
            V v = tourIterator.next();
            E e = graph.getEdge(u, v);
            edges.add(e);
            tourWeight += graph.getEdgeWeight(e);
            u = v;
        }
        E e = graph.getEdge(u, first2);
        edges.add(e);
        tour.add(first2);
        return new GraphWalk<V, E>(graph, first2, first2, tour, edges, tourWeight += graph.getEdgeWeight(e));
    }

    protected GraphPath<V, E> edgeSetToTour(Set<E> tour, Graph<V, E> graph) {
        Object first2;
        ArrayList vertices = new ArrayList(tour.size() + 1);
        ArrayList<E> edges = new ArrayList<E>(tour.size());
        double tourWeight = 0.0;
        DepthFirstIterator<Object, Object> tourIterator = new DepthFirstIterator<Object, Object>(new MaskSubgraph<Object, Object>(graph, v -> false, e -> !tour.contains(e)));
        Object u = first2 = tourIterator.next();
        while (tourIterator.hasNext()) {
            vertices.add(u);
            Object v2 = tourIterator.next();
            E e2 = graph.getEdge(u, v2);
            edges.add(e2);
            tourWeight += graph.getEdgeWeight(e2);
            u = v2;
        }
        vertices.add(u);
        vertices.add(first2);
        E e3 = graph.getEdge(u, first2);
        edges.add(e3);
        return new GraphWalk<V, E>(graph, first2, first2, vertices, edges, tourWeight += graph.getEdgeWeight(e3));
    }

    protected GraphPath<V, E> getSingletonTour(Graph<V, E> graph) {
        assert (graph.vertexSet().size() == 1);
        V start = graph.vertexSet().iterator().next();
        return new GraphWalk<V, E>(graph, start, start, Collections.singletonList(start), Collections.emptyList(), 0.0);
    }

    protected void checkGraph(Graph<V, E> graph) {
        if (!GraphTests.isComplete(graph = GraphTests.requireUndirected(graph))) {
            throw new IllegalArgumentException("Graph is not complete");
        }
        if (graph.vertexSet().isEmpty()) {
            throw new IllegalArgumentException("Graph contains no vertices");
        }
    }
}

