/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.generate;

import java.util.Map;
import java.util.Set;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.generate.GraphGenerator;
import paper.libs.org.jgrapht.util.CollectionUtil;

public class CompleteBipartiteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private final int sizeA;
    private final int sizeB;
    private final Set<V> partitionA;
    private final Set<V> partitionB;

    public CompleteBipartiteGraphGenerator(int partitionA, int partitionB) {
        if (partitionA < 0 || partitionB < 0) {
            throw new IllegalArgumentException("partition sizes must be non-negative");
        }
        this.sizeA = partitionA;
        this.sizeB = partitionB;
        this.partitionA = CollectionUtil.newLinkedHashSetWithExpectedSize(this.sizeA);
        this.partitionB = CollectionUtil.newLinkedHashSetWithExpectedSize(this.sizeB);
    }

    public CompleteBipartiteGraphGenerator(Set<V> partitionA, Set<V> partitionB) {
        if (partitionA.isEmpty() || partitionB.isEmpty()) {
            throw new IllegalArgumentException("partitions must be non-empty");
        }
        this.sizeA = 0;
        this.sizeB = 0;
        this.partitionA = partitionA;
        this.partitionB = partitionB;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        int i2;
        for (i2 = 0; i2 < this.sizeA; ++i2) {
            this.partitionA.add(target.addVertex());
        }
        for (i2 = 0; i2 < this.sizeB; ++i2) {
            this.partitionB.add(target.addVertex());
        }
        for (V u : this.partitionA) {
            for (V v : this.partitionB) {
                target.addEdge(u, v);
            }
        }
    }
}

