/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.generate;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.generate.GraphGenerator;

public class GridGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String CORNER_VERTEX = "Corner Vertex";
    private final int rows;
    private final int cols;

    public GridGraphGenerator(int rows, int cols) {
        if (rows < 2) {
            throw new IllegalArgumentException("illegal number of rows (" + rows + "). there must be at least two.");
        }
        if (cols < 2) {
            throw new IllegalArgumentException("illegal number of columns (" + cols + "). there must be at least two.");
        }
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        TreeMap<Integer, V> map2 = new TreeMap<Integer, V>();
        int cornerCtr = 0;
        for (int i2 = 0; i2 < this.rows * this.cols; ++i2) {
            boolean isCorner;
            V vertex = target.addVertex();
            map2.put(i2 + 1, vertex);
            boolean bl = isCorner = i2 == 0 || i2 == this.cols - 1 || i2 == this.cols * (this.rows - 1) || i2 == this.rows * this.cols - 1;
            if (!isCorner || resultMap == null) continue;
            resultMap.put("Corner Vertex " + ++cornerCtr, vertex);
        }
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            int i3 = (Integer)iterator.next();
            Iterator iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                if ((i3 % this.cols <= 0 || i3 + 1 != j) && i3 + this.cols != j) continue;
                target.addEdge(map2.get(i3), map2.get(j));
                target.addEdge(map2.get(j), map2.get(i3));
            }
        }
    }
}

