/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Hash;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import paper.libs.org.apache.http.Header;
import paper.libs.org.apache.http.HttpEntity;
import paper.libs.org.apache.http.HttpHost;
import paper.libs.org.apache.http.client.config.RequestConfig;
import paper.libs.org.apache.http.client.methods.CloseableHttpResponse;
import paper.libs.org.apache.http.client.methods.HttpGet;
import paper.libs.org.apache.http.client.utils.DateUtils;
import paper.libs.org.apache.http.impl.client.CloseableHttpClient;
import paper.libs.org.apache.http.impl.client.HttpClientBuilder;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0011H\u0002J(\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/papermc/paperweight/DownloadService;", "Lorg/gradle/api/services/BuildService;", "Lio/papermc/paperweight/DownloadService$Params;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "httpClient", "Lpaper/libs/org/apache/http/impl/client/CloseableHttpClient;", "download", "", "source", "", "target", "hash", "Lio/papermc/paperweight/util/Hash;", "Ljava/net/URL;", "Ljava/nio/file/Path;", "retry", "", "handleResponse", "Ljava/time/Instant;", "response", "Lpaper/libs/org/apache/http/client/methods/CloseableHttpResponse;", "saveEtag", "lastModified", "etagFile", "close", "Params", "Companion", "paperweight-lib"})
public abstract class DownloadService
implements BuildService<Params>,
AutoCloseable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private static final Logger LOGGER;

    public DownloadService() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        DownloadService downloadService = this;
        boolean bl = false;
        builder.setRetryHandler(httpClient.1.1.INSTANCE);
        builder.useSystemProperties();
        CloseableHttpClient closeableHttpClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"let(...)");
        downloadService.httpClient = closeableHttpClient;
    }

    public final void download(@NotNull Object source, @NotNull Object target, @Nullable Hash hash2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        URL url = UtilsKt.convertToUrl(source);
        Path file2 = UtilsKt.convertToPath(target);
        DownloadService.download$default(this, url, file2, hash2, false, 8, null);
    }

    public static /* synthetic */ void download$default(DownloadService downloadService, Object object, Object object2, Hash hash2, int n, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: download");
        }
        if ((n & 4) != 0) {
            hash2 = null;
        }
        downloadService.download(object, object2, hash2);
    }

    private final void download(URL source, Path target, Hash hash2, boolean retry2) {
        this.download(source, target);
        if (hash2 == null) {
            return;
        }
        Object[] objectArray = UtilsKt.asHexString(FileKt.hashFile(target, hash2.getAlgorithm()));
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string = objectArray.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String dlHash = string;
        if (Intrinsics.areEqual((Object)hash2.getValue(), (Object)"") || Intrinsics.areEqual((Object)dlHash, (Object)hash2.getValueLower())) {
            return;
        }
        objectArray = new Object[]{hash2.getAlgorithm().name(), target, hash2.getValueLower(), dlHash};
        LOGGER.warn("{} hash of downloaded file '{}' does not match what was expected! (expected: '{}', got: '{}')", objectArray);
        if (retry2) {
            throw new PaperweightException("Failed to download file '" + target + "' from '" + source + "'.");
        }
        LOGGER.warn("Re-attempting download once before giving up.");
        Files.deleteIfExists(target);
        this.download(source, target, hash2, true);
    }

    static /* synthetic */ void download$default(DownloadService downloadService, URL uRL, Path path, Hash hash2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: download");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        downloadService.download(uRL, path, hash2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void download(URL source, Path target) {
        Instant instant;
        Path path = target.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        if (Intrinsics.areEqual((Object)source.getProtocol(), (Object)"file")) {
            String string = source.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String path3 = StringsKt.replace$default((String)string, (String)"file://", (String)"", (boolean)false, (int)4, null);
            if (Intrinsics.areEqual((Object)source.getHost(), (Object)"project")) {
                path3 = StringsKt.replace$default((String)path3, (String)"project", (String)((Object)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Params)this.getParameters()).getProjectPath())).toAbsolutePath()).toString(), (boolean)false, (int)4, null);
            }
            Path path4 = Path.of(path3, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"of(...)");
            object = path4;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, target, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
            return;
        }
        Path etagDir = target.resolveSibling("etags");
        Intrinsics.checkNotNull((Object)etagDir);
        object = etagDir;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path etagFile = etagDir.resolve(PathsKt.getName((Path)target) + ".etag");
        Intrinsics.checkNotNull((Object)etagFile);
        Path path5 = etagFile;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        String etag = Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText$default((Path)etagFile, null, (int)1, null) : null;
        HttpHost host = new HttpHost(source.getHost(), source.getPort(), source.getProtocol());
        Path path6 = target;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(path6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            path6 = target;
            linkOptionArray2 = new LinkOption[]{};
            FileTime fileTime = Files.getLastModifiedTime(path6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            instant = fileTime.toInstant();
        } else {
            instant = Instant.EPOCH;
        }
        Instant time = instant;
        HttpGet httpGet = new HttpGet(source.getFile());
        int timeouts = (int)TimeUnit.MINUTES.toMillis(5L);
        httpGet.setConfig(RequestConfig.custom().setConnectTimeout(timeouts).setConnectionRequestTimeout(timeouts).setSocketTimeout(timeouts).setCookieSpec("standard").build());
        Object object2 = target;
        Object object3 = new LinkOption[]{};
        if (Files.exists((Path)object2, Arrays.copyOf(object3, ((LinkOption[])object3).length))) {
            if (!Intrinsics.areEqual((Object)time, (Object)Instant.EPOCH)) {
                String value2 = DateTimeFormatter.RFC_1123_DATE_TIME.format(time.atZone(ZoneOffset.UTC));
                httpGet.setHeader("If-Modified-Since", value2);
            }
            if (etag != null) {
                httpGet.setHeader("If-None-Match", etag);
            }
        }
        object2 = this.httpClient.execute(host, httpGet);
        object3 = null;
        try {
            CloseableHttpResponse response = (CloseableHttpResponse)object2;
            boolean bl = false;
            int code = response.getStatusLine().getStatusCode();
            if (!(200 <= code ? code < 300 : false) && code != 304) {
                String reason = response.getStatusLine().getReasonPhrase();
                throw new PaperweightException("Download failed, HTTP code: " + code + "; URL: " + source + "; Reason: " + reason);
            }
            Intrinsics.checkNotNull((Object)response);
            Instant lastModified = this.handleResponse(response, target);
            this.saveEtag(response, lastModified, target, etagFile);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Instant handleResponse(CloseableHttpResponse response, Path target) {
        Instant instant;
        Header $this$handleResponse_u24lambda_u242 = response.getLastHeader("Last-Modified");
        boolean bl = false;
        if ($this$handleResponse_u24lambda_u242 == null) {
            instant = Instant.EPOCH;
        } else {
            CharSequence charSequence = $this$handleResponse_u24lambda_u242.getValue();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                instant = Instant.EPOCH;
            } else {
                instant = DateUtils.parseDate($this$handleResponse_u24lambda_u242.getValue()).toInstant();
                if (instant == null) {
                    instant = Instant.EPOCH;
                }
            }
        }
        Instant lastModified = instant;
        if (response.getStatusLine().getStatusCode() == 304) {
            Intrinsics.checkNotNull((Object)lastModified);
            return lastModified;
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            Intrinsics.checkNotNull((Object)lastModified);
            return lastModified;
        }
        HttpEntity entity = httpEntity;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(target, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            long l;
            OutputStream output = (OutputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = entity.getContent();
            Throwable throwable2 = null;
            try {
                InputStream input = (InputStream)closeable2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)input);
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNull((Object)lastModified);
        return lastModified;
    }

    private final void saveEtag(CloseableHttpResponse response, Instant lastModified, Path target, Path etagFile) {
        if (!Intrinsics.areEqual((Object)lastModified, (Object)Instant.EPOCH)) {
            Path path = target;
            FileTime fileTime = FileTime.from(lastModified);
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Files.setLastModifiedTime(path, fileTime), (String)"setLastModifiedTime(...)");
        }
        Header header = response.getFirstHeader("ETag");
        if (header == null) {
            return;
        }
        Header header2 = header;
        String etag = header2.getValue();
        Intrinsics.checkNotNull((Object)etag);
        PathsKt.writeText$default((Path)etagFile, (CharSequence)etag, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    static {
        Logger logger = Logging.getLogger(DownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/papermc/paperweight/DownloadService$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "getLOGGER", "()Lorg/gradle/api/logging/Logger;", "paperweight-lib"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/DownloadService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "projectPath", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectPath", "()Lorg/gradle/api/file/DirectoryProperty;", "paperweight-lib"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public DirectoryProperty getProjectPath();
    }
}

