/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.userdev.internal.action.FileCollectionValue;
import io.papermc.paperweight.userdev.internal.action.FileValue;
import io.papermc.paperweight.userdev.internal.action.StringValue;
import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.userdev.internal.action.ValuesKt;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcher;
import io.papermc.paperweight.userdev.internal.setup.BundleInfo;
import io.papermc.paperweight.userdev.internal.setup.SetupHandler;
import io.papermc.paperweight.userdev.internal.setup.SetupHandlerImpl;
import io.papermc.paperweight.userdev.internal.setup.UserdevSetup;
import io.papermc.paperweight.userdev.internal.setup.UserdevSetupTask;
import io.papermc.paperweight.userdev.internal.setup.action.ApplyDevBundlePatchesAction;
import io.papermc.paperweight.userdev.internal.setup.action.ExtractFromBundlerAction;
import io.papermc.paperweight.userdev.internal.setup.action.RunCodebookAction;
import io.papermc.paperweight.userdev.internal.setup.action.RunPaperclipAction;
import io.papermc.paperweight.userdev.internal.setup.action.SetupMacheSourcesAction;
import io.papermc.paperweight.userdev.internal.setup.action.VanillaServerDownloads;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.MavenDep;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.data.mache.MacheMeta;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.jvm.toolchain.JavaLauncher;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u0004\u0018\u00010(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0016\u0010-\u001a\u0004\u0018\u00010(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u0014\u0010/\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010*R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020 0$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010&\u00a8\u00063"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/SetupHandlerImpl;", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler;", "parameters", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Parameters;", "bundle", "Lio/papermc/paperweight/userdev/internal/setup/BundleInfo;", "Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "<init>", "(Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Parameters;Lio/papermc/paperweight/userdev/internal/setup/BundleInfo;)V", "macheMeta", "Lio/papermc/paperweight/util/data/mache/MacheMeta;", "createDispatcher", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher;", "context", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$ExecutionContext;", "populateCompileConfiguration", "", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$ConfigurationContext;", "dependencySet", "Lorg/gradle/api/artifacts/DependencySet;", "populateRuntimeConfiguration", "completedOutput", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$ArtifactsResult;", "generateArtifacts", "extractReobfMappings", "output", "Ljava/nio/file/Path;", "setupMacheMeta", "macheFiles", "Lorg/gradle/api/file/FileCollection;", "afterEvaluate", "minecraftVersion", "", "getMinecraftVersion", "()Ljava/lang/String;", "pluginRemapArgs", "", "getPluginRemapArgs", "()Ljava/util/List;", "paramMappings", "Lio/papermc/paperweight/util/MavenDep;", "getParamMappings", "()Lio/papermc/paperweight/util/MavenDep;", "decompiler", "getDecompiler", "remapper", "getRemapper", "mache", "getMache", "libraryRepositories", "getLibraryRepositories", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nSetupHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupHandlerImpl.kt\nio/papermc/paperweight/userdev/internal/setup/SetupHandlerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 GradleApiKotlinDslExtensions_3sx1g6kmdmnb8jxwpxvm4pxs0.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions_3sx1g6kmdmnb8jxwpxvm4pxs0Kt\n*L\n1#1,263:1\n1#2:264\n40#3:265\n*S KotlinDebug\n*F\n+ 1 SetupHandlerImpl.kt\nio/papermc/paperweight/userdev/internal/setup/SetupHandlerImpl\n*L\n230#1:265\n*E\n"})
public final class SetupHandlerImpl
implements SetupHandler {
    @NotNull
    private final UserdevSetup.Parameters parameters;
    @NotNull
    private final BundleInfo<GenerateDevBundle.DevBundleConfig> bundle;
    @Nullable
    private MacheMeta macheMeta;
    @Nullable
    private volatile SetupHandler.ArtifactsResult completedOutput;

    public SetupHandlerImpl(@NotNull UserdevSetup.Parameters parameters, @NotNull BundleInfo<GenerateDevBundle.DevBundleConfig> bundle) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(bundle, (String)"bundle");
        this.parameters = parameters;
        this.bundle = bundle;
    }

    private final WorkDispatcher createDispatcher(SetupHandler.ExecutionContext context) {
        WorkDispatcher dispatcher = WorkDispatcher.Companion.create(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.parameters.getCache())));
        Object object = this.parameters.getBundleZipHash().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        dispatcher.overrideTerminalInputHash((String)object);
        Value<JavaLauncher> javaLauncher = ValuesKt.javaLauncherValue(context.getJavaLauncher());
        StringValue mcVer = new StringValue(this.bundle.getConfig().getMinecraftVersion());
        FileValue bundleZip = ValuesKt.fileValue(this.bundle.getZip());
        Value[] valueArray = new Value[]{javaLauncher, mcVer, bundleZip};
        dispatcher.provided(valueArray);
        FileValue fileValue = dispatcher.outputFile("vanillaServer.jar");
        FileValue fileValue2 = dispatcher.outputFile("mojangServerMappings.txt");
        Object object2 = this.parameters.getDownloadService().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        VanillaServerDownloads vanillaDownloads = (VanillaServerDownloads)dispatcher.register("vanillaServerDownloads", (WorkDispatcher.Action)new VanillaServerDownloads(mcVer, fileValue, fileValue2, (DownloadService)object2));
        RunPaperclipAction applyPaperclip = (RunPaperclipAction)dispatcher.register("applyPaperclipPatch", (WorkDispatcher.Action)new RunPaperclipAction(javaLauncher, bundleZip, new StringValue(this.bundle.getConfig().getMojangMappedPaperclipFile()), dispatcher.outputFile("output.jar"), vanillaDownloads.getServerJar(), mcVer, false, 64, null));
        dispatcher.provided((Value<?>)applyPaperclip.getPaperclipPath());
        ExtractFromBundlerAction extract = (ExtractFromBundlerAction)dispatcher.register("extractFromBundler", (WorkDispatcher.Action)new ExtractFromBundlerAction(vanillaDownloads.getServerJar(), dispatcher.outputFile("vanillaServer.jar"), dispatcher.outputDir("minecraftLibraries")));
        RunCodebookAction remap = (RunCodebookAction)dispatcher.register("remapMinecraft", (WorkDispatcher.Action)new RunCodebookAction(javaLauncher, ValuesKt.stringListValue(this.macheMeta().getRemapperArgs()), extract.getVanillaServerJar(), extract.getMinecraftLibraryJars(), vanillaDownloads.getServerMappings(), new FileCollectionValue(context.getMacheParamMappingsConfig()), new FileCollectionValue(context.getMacheConstantsConfig()), new FileCollectionValue(context.getMacheCodebookConfig()), new FileCollectionValue(context.getMacheRemapperConfig()), dispatcher.outputFile("output.jar")));
        Value[] valueArray2 = new Value[]{remap.getMinecraftRemapArgs(), remap.getParamMappings(), remap.getConstants(), remap.getCodebook(), remap.getRemapper()};
        dispatcher.provided(valueArray2);
        SetupMacheSourcesAction macheSources = (SetupMacheSourcesAction)dispatcher.register("setupMacheSources", (WorkDispatcher.Action)new SetupMacheSourcesAction(javaLauncher, remap.getOutputJar(), dispatcher.outputFile("output.zip"), extract.getMinecraftLibraryJars(), ValuesKt.stringListValue(this.macheMeta().getDecompilerArgs()), new FileCollectionValue(context.getMacheDecompilerConfig()), new FileCollectionValue(context.getMacheConfig())));
        Value[] valueArray3 = new Value[]{macheSources.getDecompileArgs(), macheSources.getDecompiler(), macheSources.getMache()};
        dispatcher.provided(valueArray3);
        ApplyDevBundlePatchesAction applyPatches = (ApplyDevBundlePatchesAction)dispatcher.register("applyDevBundlePatches", (WorkDispatcher.Action)new ApplyDevBundlePatchesAction(macheSources.getOutputJar(), bundleZip, new StringValue(this.bundle.getConfig().getPatchDir()), dispatcher.outputFile("output.jar"), applyPaperclip.getOutputJar()));
        dispatcher.provided((Value<?>)applyPatches.getPatchesPath());
        return dispatcher;
    }

    @Override
    public void populateCompileConfiguration(@NotNull SetupHandler.ConfigurationContext context, @NotNull DependencySet dependencySet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dependencySet, (String)"dependencySet");
        Object[] objectArray = new Object[]{context.getSetupTask().flatMap((Transformer)populateCompileConfiguration.1.INSTANCE)};
        dependencySet.add((Object)context.getDependencyFactory().create(context.getLayout().files(objectArray)));
        dependencySet.add((Object)context.getDependencyFactory().create((CharSequence)context.getDevBundleCoordinates()));
    }

    @Override
    public void populateRuntimeConfiguration(@NotNull SetupHandler.ConfigurationContext context, @NotNull DependencySet dependencySet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dependencySet, (String)"dependencySet");
        this.populateCompileConfiguration(context, dependencySet);
    }

    @Override
    @NotNull
    public synchronized SetupHandler.ArtifactsResult generateArtifacts(@NotNull SetupHandler.ExecutionContext context) {
        SetupHandler.ArtifactsResult artifactsResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.completedOutput != null) {
            SetupHandler.ArtifactsResult artifactsResult2 = this.completedOutput;
            if (artifactsResult2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return artifactsResult2;
        }
        this.setupMacheMeta(context.getMacheConfig());
        WorkDispatcher dispatcher = this.createDispatcher(context);
        FileValue request = (Boolean)this.parameters.getGenSources().get() != false ? ((ApplyDevBundlePatchesAction)dispatcher.registered("applyDevBundlePatches")).getOutputJar() : ((RunPaperclipAction)dispatcher.registered("applyPaperclipPatch")).getOutputJar();
        SetupHandler.ExecutionContext.withProgressLogger$default(context, null, null, arg_0 -> SetupHandlerImpl.generateArtifacts$lambda$1(dispatcher, request, arg_0), 3, null);
        SetupHandler.ArtifactsResult it = artifactsResult = new SetupHandler.ArtifactsResult((Path)request.get(), null);
        boolean bl = false;
        this.completedOutput = it;
        return artifactsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractReobfMappings(@NotNull Path output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string = this.bundle.getConfig().getReobfMappingsFile();
        if (string != null) {
            String location = string;
            boolean bl = false;
            AutoCloseable autoCloseable = NioKt.openZipSafe(this.bundle.getZip());
            Throwable throwable = null;
            try {
                FileSystemReference fs = (FileSystemReference)autoCloseable;
                boolean bl2 = false;
                Path path = fs.getPath(location);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray2 = copyOptionArray;
                Path path2 = Files.copy(path, output, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"copy(...)");
                Path path3 = path2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    private final MacheMeta macheMeta() {
        MacheMeta macheMeta = this.macheMeta;
        if (macheMeta == null) {
            boolean bl = false;
            String string = "Mache meta is not setup yet";
            throw new IllegalArgumentException(string.toString());
        }
        return macheMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupMacheMeta(FileCollection macheFiles) {
        if (this.macheMeta == null) {
            SetupHandlerImpl setupHandlerImpl = this;
            synchronized (setupHandlerImpl) {
                boolean bl = false;
                this.macheMeta = UtilsKt.resolveMacheMeta(macheFiles);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterEvaluate(@NotNull SetupHandler.ConfigurationContext context) {
        void $this$withType$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SetupHandler.super.afterEvaluate(context);
        Configuration configuration = context.getProject().getConfigurations().getByName("mache");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        this.setupMacheMeta((FileCollection)configuration);
        ConfigurationContainer configurationContainer = context.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        ConfigurationContainer configurations = configurationContainer;
        NamedDomainObjectProvider namedDomainObjectProvider = configurations.register("macheCodebook", (Action)afterEvaluate.macheCodebook.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider, (String)"register(...)");
        NamedDomainObjectProvider macheCodebook2 = namedDomainObjectProvider;
        NamedDomainObjectProvider namedDomainObjectProvider2 = configurations.register("macheRemapper", (Action)afterEvaluate.macheRemapper.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider2, (String)"register(...)");
        NamedDomainObjectProvider macheRemapper2 = namedDomainObjectProvider2;
        NamedDomainObjectProvider namedDomainObjectProvider3 = configurations.register("macheDecompiler", (Action)afterEvaluate.macheDecompiler.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider3, (String)"register(...)");
        NamedDomainObjectProvider macheDecompiler2 = namedDomainObjectProvider3;
        NamedDomainObjectProvider namedDomainObjectProvider4 = configurations.register("macheParamMappings", (Action)afterEvaluate.macheParamMappings.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider4, (String)"register(...)");
        NamedDomainObjectProvider macheParamMappings2 = namedDomainObjectProvider4;
        NamedDomainObjectProvider namedDomainObjectProvider5 = configurations.register("macheConstants", (Action)afterEvaluate.macheConstants.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider5, (String)"register(...)");
        NamedDomainObjectProvider macheConstants2 = namedDomainObjectProvider5;
        TaskContainer taskContainer = context.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskCollection taskCollection = (TaskCollection)taskContainer;
        Class<UserdevSetupTask> type$iv = UserdevSetupTask.class;
        boolean $i$f$withType = false;
        TaskCollection taskCollection2 = $this$withType$iv.withType(type$iv);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection2, (String)"withType(...)");
        taskCollection2.configureEach(new Action((NamedDomainObjectProvider<Configuration>)macheCodebook2, (NamedDomainObjectProvider<Configuration>)macheRemapper2, (NamedDomainObjectProvider<Configuration>)macheDecompiler2, (NamedDomainObjectProvider<Configuration>)macheParamMappings2, (NamedDomainObjectProvider<Configuration>)macheConstants2){
            final /* synthetic */ NamedDomainObjectProvider<Configuration> $macheCodebook;
            final /* synthetic */ NamedDomainObjectProvider<Configuration> $macheRemapper;
            final /* synthetic */ NamedDomainObjectProvider<Configuration> $macheDecompiler;
            final /* synthetic */ NamedDomainObjectProvider<Configuration> $macheParamMappings;
            final /* synthetic */ NamedDomainObjectProvider<Configuration> $macheConstants;
            {
                this.$macheCodebook = $macheCodebook;
                this.$macheRemapper = $macheRemapper;
                this.$macheDecompiler = $macheDecompiler;
                this.$macheParamMappings = $macheParamMappings;
                this.$macheConstants = $macheConstants;
            }

            public final void execute(UserdevSetupTask $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                Object[] objectArray = new Object[]{this.$macheCodebook};
                $this$configureEach.getMacheCodebookConfig().from(objectArray);
                objectArray = new Object[]{this.$macheRemapper};
                $this$configureEach.getMacheRemapperConfig().from(objectArray);
                objectArray = new Object[]{this.$macheDecompiler};
                $this$configureEach.getMacheDecompilerConfig().from(objectArray);
                objectArray = new Object[]{this.$macheParamMappings};
                $this$configureEach.getMacheParamMappingsConfig().from(objectArray);
                objectArray = new Object[]{this.$macheConstants};
                $this$configureEach.getMacheConstantsConfig().from(objectArray);
            }
        });
        this.macheMeta().addDependencies(context.getProject());
        this.macheMeta().addRepositories(context.getProject());
    }

    @Override
    @NotNull
    public String getMinecraftVersion() {
        return this.bundle.getConfig().getMinecraftVersion();
    }

    @Override
    @NotNull
    public List<String> getPluginRemapArgs() {
        return this.bundle.getConfig().getPluginRemapArgs();
    }

    @Override
    @Nullable
    public MavenDep getParamMappings() {
        return null;
    }

    @Override
    @Nullable
    public MavenDep getDecompiler() {
        return null;
    }

    @Override
    @Nullable
    public MavenDep getRemapper() {
        return null;
    }

    @Override
    @NotNull
    public MavenDep getMache() {
        return this.bundle.getConfig().getMache();
    }

    @Override
    @NotNull
    public List<String> getLibraryRepositories() {
        return this.bundle.getConfig().getLibraryRepositories();
    }

    private static final Unit generateArtifacts$lambda$1$lambda$0(ProgressLogger $progressLogger, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $progressLogger.progress(it);
        return Unit.INSTANCE;
    }

    private static final Unit generateArtifacts$lambda$1(WorkDispatcher $dispatcher, FileValue $request, ProgressLogger progressLogger) {
        Intrinsics.checkNotNullParameter((Object)progressLogger, (String)"progressLogger");
        Value[] valueArray = new Value[]{$request};
        $dispatcher.dispatch(valueArray, (Function1<? super String, Unit>)((Function1)arg_0 -> SetupHandlerImpl.generateArtifacts$lambda$1$lambda$0(progressLogger, arg_0)));
        return Unit.INSTANCE;
    }
}

