/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.ClassNodeCache;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.ClassReader;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\n\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bj\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/papermc/paperweight/util/ClassNodeCacheImpl;", "Lio/papermc/paperweight/util/ClassNodeCache;", "jarFile", "Ljava/nio/file/FileSystem;", "fallbackJars", "", "fallbackDirectories", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/FileSystem;Ljava/util/List;Ljava/util/List;)V", "classNodeMap", "Ljava/util/HashMap;", "", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "Lkotlin/collections/HashMap;", "findClass", "name", "findClassData", "", "className", "normalize", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nClassNodeCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNodeCacheImpl.kt\nio/papermc/paperweight/util/ClassNodeCacheImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class ClassNodeCacheImpl
implements ClassNodeCache {
    @NotNull
    private final FileSystem jarFile;
    @NotNull
    private final List<FileSystem> fallbackJars;
    @Nullable
    private final List<Path> fallbackDirectories;
    @NotNull
    private final HashMap<String, ClassNode> classNodeMap;

    public ClassNodeCacheImpl(@NotNull FileSystem jarFile, @NotNull List<? extends FileSystem> fallbackJars, @Nullable List<? extends Path> fallbackDirectories) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter(fallbackJars, (String)"fallbackJars");
        this.jarFile = jarFile;
        this.fallbackJars = fallbackJars;
        this.fallbackDirectories = fallbackDirectories;
        this.classNodeMap = new HashMap();
    }

    public /* synthetic */ ClassNodeCacheImpl(FileSystem fileSystem, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        this(fileSystem, list, list2);
    }

    @Override
    @Nullable
    public ClassNode findClass(@Nullable String name2) {
        if (name2 == null) {
            return null;
        }
        return this.classNodeMap.computeIfAbsent(this.normalize(name2), new Function(this){
            final /* synthetic */ ClassNodeCacheImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final ClassNode apply(String fileName) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                byte[] byArray2 = ClassNodeCacheImpl.access$findClassData(this.this$0, fileName);
                if (byArray2 == null) {
                    return null;
                }
                byte[] classData = byArray2;
                ClassReader classReader = new ClassReader(classData);
                ClassNode node = new ClassNode(589824);
                classReader.accept(node, 0);
                return node;
            }
        });
    }

    private final byte[] findClassData(String className) {
        Path remappedClass = this.jarFile.getPath(className, new String[0]);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)remappedClass);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(remappedClass, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            byte[] byArray2 = Files.readAllBytes(remappedClass);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
            return byArray2;
        }
        for (FileSystem fallbackJar : this.fallbackJars) {
            Object object = fallbackJar;
            if (object == null || (object = ((FileSystem)object).getPath(className, new String[0])) == null) continue;
            Object libraryClass = object;
            boolean bl2 = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists((Path)libraryClass, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
            byte[] byArray3 = Files.readAllBytes((Path)libraryClass);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"readAllBytes(...)");
            return byArray3;
        }
        List<Path> list = this.fallbackDirectories;
        if (list != null) {
            List<Path> dirs = list;
            boolean bl3 = false;
            for (Path path : dirs) {
                Path path2;
                Path it = path2 = path.resolve(className);
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                Path path3 = Files.exists(it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? path2 : null;
                if (path3 == null) continue;
                Path libraryClass = path3;
                boolean bl5 = false;
                LinkOption[] linkOptionArray4 = new LinkOption[]{};
                if (!Files.exists(libraryClass, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) continue;
                byte[] byArray4 = Files.readAllBytes(libraryClass);
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"readAllBytes(...)");
                return byArray4;
            }
        }
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(className);
        return (byte[])(inputStream != null ? ByteStreamsKt.readBytes((InputStream)inputStream) : null);
    }

    private final String normalize(String name2) {
        String workingName = StringsKt.removeSuffix((String)name2, (CharSequence)".class");
        int startIndex = 0;
        int endIndex = workingName.length();
        if (StringsKt.startsWith$default((CharSequence)workingName, (char)'L', (boolean)false, (int)2, null)) {
            startIndex = 1;
        }
        if (StringsKt.endsWith$default((CharSequence)workingName, (char)';', (boolean)false, (int)2, null)) {
            --endIndex;
        }
        String string = workingName.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
    }

    public static final /* synthetic */ byte[] access$findClassData(ClassNodeCacheImpl $this, String className) {
        return $this.findClassData(className);
    }
}

