/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.DelegatingOutputStream;
import io.papermc.paperweight.util.UselessOutputStream;
import io.papermc.paperweight.util.constants.ConstantsKt;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0006\u0010\u0016\u001a\u00020\u0013J\u001e\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/papermc/paperweight/util/Command;", "", "processBuilder", "Ljava/lang/ProcessBuilder;", "command", "", "<init>", "(Ljava/lang/ProcessBuilder;Ljava/lang/String;)V", "outStream", "Ljava/io/OutputStream;", "errStream", "run", "", "runSilently", "silenceOut", "", "silenceErr", "runOut", "execute", "", "executeSilently", "silence", "executeOut", "setup", "out", "err", "getText", "readText", "captureOut", "Lio/papermc/paperweight/util/Command$Result;", "logOut", "Result", "paperweight-lib"})
public final class Command {
    @NotNull
    private final ProcessBuilder processBuilder;
    @NotNull
    private final String command;
    @NotNull
    private OutputStream outStream;
    @NotNull
    private OutputStream errStream;

    public Command(@NotNull ProcessBuilder processBuilder, @NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        this.processBuilder = processBuilder;
        this.command = command2;
        this.outStream = UselessOutputStream.INSTANCE;
        this.errStream = UselessOutputStream.INSTANCE;
    }

    public final int run() {
        if (ConstantsKt.paperweightDebug()) {
            OutputStream[] outputStreamArray = new OutputStream[2];
            outputStreamArray[0] = this.outStream;
            Intrinsics.checkNotNullExpressionValue((Object)System.out, (String)"out");
            OutputStream outputStream = new DelegatingOutputStream(outputStreamArray);
            outputStreamArray = new OutputStream[2];
            outputStreamArray[0] = this.errStream;
            Intrinsics.checkNotNullExpressionValue((Object)System.err, (String)"err");
            this.setup(outputStream, new DelegatingOutputStream(outputStreamArray));
            System.out.println();
            System.out.println((Object)("$ (pwd) " + this.processBuilder.directory().getAbsolutePath()));
            System.out.println((Object)("$ " + this.command));
        }
        try {
            Process process = this.processBuilder.start();
            InputStream input = process.getInputStream();
            InputStream error = process.getErrorStream();
            byte[] buffer = new byte[1000];
            while (process.isAlive()) {
                int count2;
                if (input.available() > 0) {
                    count2 = input.read(buffer);
                    this.outStream.write(buffer, 0, count2);
                }
                if (error.available() > 0) {
                    count2 = error.read(buffer);
                    this.errStream.write(buffer, 0, count2);
                }
                Thread.sleep(1L);
            }
            Intrinsics.checkNotNull((Object)input);
            this.outStream.write(ByteStreamsKt.readBytes((InputStream)input));
            Intrinsics.checkNotNull((Object)error);
            this.errStream.write(ByteStreamsKt.readBytes((InputStream)error));
            return process.waitFor();
        }
        catch (Exception e) {
            throw new PaperweightException("Failed to call git command: " + this.command, e);
        }
    }

    public final int runSilently(boolean silenceOut, boolean silenceErr) {
        this.silence(silenceOut, silenceErr);
        return this.run();
    }

    public static /* synthetic */ int runSilently$default(Command command2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return command2.runSilently(bl, bl2);
    }

    public final int runOut() {
        this.setup(System.out, System.err);
        return this.run();
    }

    public final void execute() {
        int res = this.run();
        if (res != 0) {
            throw new PaperweightException("Command finished with " + res + " exit code: " + this.command);
        }
    }

    public final void executeSilently(boolean silenceOut, boolean silenceErr) {
        this.silence(silenceOut, silenceErr);
        this.execute();
    }

    public static /* synthetic */ void executeSilently$default(Command command2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        command2.executeSilently(bl, bl2);
    }

    private final void silence(boolean silenceOut, boolean silenceErr) {
        PrintStream out = silenceOut ? null : System.out;
        PrintStream err = silenceErr ? null : System.err;
        this.setup(out, err);
    }

    public final void executeOut() {
        this.setup(System.out, System.err);
        this.execute();
    }

    @NotNull
    public final Command setup(@Nullable OutputStream out, @Nullable OutputStream err) {
        OutputStream outputStream;
        OutputStream outputStream2 = out;
        if (outputStream2 == null) {
            outputStream2 = this.outStream = (OutputStream)UselessOutputStream.INSTANCE;
        }
        if ((outputStream = err) == null) {
            outputStream = UselessOutputStream.INSTANCE;
        }
        this.errStream = outputStream;
        return this;
    }

    public static /* synthetic */ Command setup$default(Command command2, OutputStream outputStream, OutputStream outputStream2, int n, Object object) {
        if ((n & 1) != 0) {
            outputStream = null;
        }
        if ((n & 2) != 0) {
            outputStream2 = null;
        }
        return command2.setup(outputStream, outputStream2);
    }

    @NotNull
    public final String getText() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setup(out, System.err);
        this.execute();
        byte[] byArray2 = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        byte[] byArray3 = byArray2;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset charset2 = charset;
        return new String(byArray3, charset2);
    }

    @Nullable
    public final String readText() {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setup(out, System.err);
        if (this.run() == 0) {
            byte[] byArray2 = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byte[] byArray3 = byArray2;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            Charset charset2 = charset;
            string = new String(byArray3, charset2);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Result captureOut(boolean logOut) {
        Command $this$captureOut_u24lambda_u240 = this;
        boolean bl = false;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (logOut) {
            OutputStream[] outputStreamArray = new OutputStream[2];
            Intrinsics.checkNotNullExpressionValue((Object)System.out, (String)"out");
            outputStreamArray[1] = out;
            DelegatingOutputStream combined = new DelegatingOutputStream(outputStreamArray);
            v0 = $this$captureOut_u24lambda_u240.setup(combined, combined);
        } else {
            v0 = $this$captureOut_u24lambda_u240.setup(out, out);
        }
        int n = $this$captureOut_u24lambda_u240.run();
        byte[] byArray2 = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        byte[] byArray3 = byArray2;
        return new Result(n, new String(byArray3, Charsets.UTF_8));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/papermc/paperweight/util/Command$Result;", "", "exit", "", "out", "", "<init>", "(ILjava/lang/String;)V", "getExit", "()I", "getOut", "()Ljava/lang/String;", "paperweight-lib"})
    public static final class Result {
        private final int exit;
        @NotNull
        private final String out;

        public Result(int exit, @NotNull String out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.exit = exit;
            this.out = out;
        }

        public final int getExit() {
            return this.exit;
        }

        @NotNull
        public final String getOut() {
            return this.out;
        }
    }
}

