/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.InvalidDurationException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"units", "", "", "Ljava/time/temporal/ChronoUnit;", "parseDuration", "Ljava/time/Duration;", "input", "", "paperweight-lib"})
public final class DurationsKt {
    @NotNull
    private static final Map<Character, ChronoUnit> units;

    @NotNull
    public static final Duration parseDuration(@NotNull String input) throws InvalidDurationException {
        long l;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (StringsKt.isBlank((CharSequence)input)) {
            throw InvalidDurationException.Companion.noInput(input);
        }
        if (input.length() < 2) {
            throw InvalidDurationException.Companion.invalidInput$default(InvalidDurationException.Companion, input, null, 2, null);
        }
        char unitAbbreviation = StringsKt.last((CharSequence)input);
        ChronoUnit chronoUnit = units.get(Character.valueOf(unitAbbreviation));
        if (chronoUnit == null) {
            throw InvalidDurationException.Companion.invalidInput$default(InvalidDurationException.Companion, input, null, 2, null);
        }
        ChronoUnit unit = chronoUnit;
        try {
            String string = input.substring(0, input.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            l = Long.parseLong(string);
        }
        catch (NumberFormatException ex) {
            throw InvalidDurationException.Companion.invalidInput(input, ex);
        }
        long length = l;
        Duration duration = Duration.of(length, unit);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
        return duration;
    }

    public static final /* synthetic */ Map access$getUnits$p() {
        return units;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('d'), (Object)ChronoUnit.DAYS), TuplesKt.to((Object)Character.valueOf('h'), (Object)ChronoUnit.HOURS), TuplesKt.to((Object)Character.valueOf('m'), (Object)ChronoUnit.MINUTES), TuplesKt.to((Object)Character.valueOf('s'), (Object)ChronoUnit.SECONDS)};
        units = MapsKt.mapOf((Pair[])pairArray);
    }
}

