/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.File_lockKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a;\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\u00a2\u0006\u0002\u0010\f\u001a0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"openCurrentJvm", "", "Ljava/nio/file/Path;", "Ljava/util/concurrent/locks/ReentrantLock;", "withLock", "R", "lockFile", "printInfoAfter", "", "timeoutMs", "action", "Lkotlin/Function0;", "(Ljava/nio/file/Path;JJLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "acquireProcessLockWaiting", "", "logger", "Lorg/gradle/api/logging/Logger;", "alreadyWaited", "paperweight-lib"})
public final class File_lockKt {
    @NotNull
    private static final Map<Path, ReentrantLock> openCurrentJvm = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R> R withLock(@NotNull Path lockFile, long printInfoAfter, long timeoutMs, @NotNull Function0<? extends R> action) {
        ReentrantLock lock2;
        Path normalized;
        Intrinsics.checkNotNullParameter((Object)lockFile, (String)"lockFile");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Logger logger = Logging.getLogger((String)"paperweight lock file");
        long waitedMs = 0L;
        boolean firstFailedAcquire = true;
        while (true) {
            Path path = lockFile.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
            Intrinsics.checkNotNullExpressionValue((Object)path.toAbsolutePath(), (String)"toAbsolutePath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)openCurrentJvm.computeIfAbsent(normalized, withLock.lock.1.INSTANCE), (String)"computeIfAbsent(...)");
            if (!lock2.tryLock()) {
                if (firstFailedAcquire) {
                    logger.lifecycle("Lock for '" + lockFile + "' is currently held by another thread.");
                    logger.lifecycle("Waiting for lock to be released...");
                    firstFailedAcquire = false;
                }
                long startWait = System.nanoTime();
                boolean acquired = lock2.tryLock(printInfoAfter, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    if ((waitedMs += (System.nanoTime() - startWait) / (long)1000000) >= timeoutMs) {
                        throw new PaperweightException("Have been waiting on lock for '" + lockFile + "' for " + waitedMs + " ms. Giving up as timeout is " + timeoutMs + " ms.");
                    }
                    logger.lifecycle("Have been waiting on lock for '" + lockFile + "' for " + waitedMs / (long)1000 / (long)60 + " minute(s).\nIf this persists for an unreasonable length of time, kill this process, run './gradlew --stop', and then try again.");
                }
            }
            if (openCurrentJvm.get(normalized) == lock2) break;
            lock2.unlock();
        }
        try {
            Object object;
            Intrinsics.checkNotNull((Object)logger);
            File_lockKt.acquireProcessLockWaiting(lockFile, logger, waitedMs, printInfoAfter, timeoutMs);
            try {
                object = action.invoke();
            }
            catch (Throwable throwable) {
                FileKt.deleteForcefully(lockFile);
                throw throwable;
            }
            FileKt.deleteForcefully(lockFile);
            return (R)object;
        }
        finally {
            openCurrentJvm.remove(normalized);
            lock2.unlock();
        }
    }

    public static /* synthetic */ Object withLock$default(Path path, long l, long l2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 300000L;
        }
        if ((n & 4) != 0) {
            l2 = 3600000L;
        }
        return File_lockKt.withLock(path, l, l2, function0);
    }

    private static final void acquireProcessLockWaiting(Path lockFile, Logger logger, long alreadyWaited, long printInfoAfter, long timeoutMs) {
        Path path = lockFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        Object[] objectArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(objectArray, objectArray.length))) {
            Path path3 = lockFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            path2 = path3;
            objectArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"createDirectories(...)");
        }
        long currentPid = ProcessHandle.current().pid();
        long sleptMs = alreadyWaited;
        while (true) {
            block9: {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(lockFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    long lockingProcessId = Long.parseLong(PathsKt.readText$default((Path)lockFile, null, (int)1, null));
                    if (lockingProcessId == currentPid) {
                        throw new IllegalStateException("Lock file '" + lockFile + "' is currently held by this process.");
                    }
                    logger.lifecycle("Lock file '" + lockFile + "' is currently held by pid '" + lockingProcessId + "'.");
                    if (ProcessHandle.of(lockingProcessId).isEmpty()) {
                        logger.lifecycle("Locking process does not exist, assuming abrupt termination and deleting lock file.");
                        Files.deleteIfExists(lockFile);
                    } else {
                        logger.lifecycle("Waiting for lock to be released...");
                        do {
                            LinkOption[] linkOptionArray2 = new LinkOption[]{};
                            if (!Files.exists(lockFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block9;
                            Thread.sleep(100L);
                            if ((sleptMs += (long)100) < printInfoAfter || sleptMs % printInfoAfter != 0L) continue;
                            logger.lifecycle("Have been waiting on lock file '" + lockFile + "' held by pid '" + lockingProcessId + "' for " + sleptMs / (long)1000 / (long)60 + " minute(s).\nIf this persists for an unreasonable length of time, kill this process, run './gradlew --stop', and then try again.\nIf the problem persists, the lock file may need to be deleted manually.");
                        } while (sleptMs < timeoutMs);
                        throw new PaperweightException("Have been waiting on lock file '" + lockFile + "' for " + sleptMs + " ms. Giving up as timeout is " + timeoutMs + " ms.");
                    }
                }
            }
            try {
                OpenOption[] lockingProcessId = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.SYNC};
                PathsKt.writeText$default((Path)lockFile, (CharSequence)String.valueOf(currentPid), null, (OpenOption[])lockingProcessId, (int)2, null);
            }
            catch (FileAlreadyExistsException e) {
                continue;
            }
            break;
        }
    }
}

