/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.diff;

import java.util.Collections;
import java.util.List;
import paper.libs.codechicken.diffpatch.match.LineMatching;
import paper.libs.codechicken.diffpatch.util.CharRepresenter;
import paper.libs.codechicken.diffpatch.util.Diff;
import paper.libs.codechicken.diffpatch.util.Operation;
import paper.libs.codechicken.diffpatch.util.Patch;
import paper.libs.codechicken.repack.net.covers1624.quack.collection.FastStream;

public abstract class Differ {
    public static final int DEFAULT_CONTEXT = 3;
    protected final CharRepresenter charRep;

    public Differ() {
        this(null);
    }

    public Differ(CharRepresenter charRep) {
        if (charRep == null) {
            charRep = new CharRepresenter();
        }
        this.charRep = charRep;
    }

    public abstract int[] match(List<String> var1, List<String> var2);

    public List<Diff> diff(List<String> lines1, List<String> lines2) {
        return LineMatching.makeDiffList(this.match(lines1, lines2), lines1, lines2);
    }

    public List<Patch> makePatches(List<String> lines1, List<String> lines2) {
        return this.makePatches(lines1, lines2, 3, true);
    }

    public List<Patch> makePatches(List<String> lines1, List<String> lines2, int numContextLines, boolean collate) {
        return Differ.makePatches(this.diff(lines1, lines2), numContextLines, collate);
    }

    public static List<Patch> makeFileAdded(List<String> lines) {
        return Collections.singletonList(Differ.make(lines, Operation.INSERT));
    }

    public static List<Patch> makeFileRemoved(List<String> lines) {
        return Collections.singletonList(Differ.make(lines, Operation.DELETE));
    }

    public static List<Patch> makePatches(List<Diff> diffs, int numContextLines, boolean collate) {
        Patch p = new Patch();
        p.diffs = diffs;
        p.recalculateLength();
        p.trim(numContextLines);
        if (p.length1 == 0) {
            return Collections.emptyList();
        }
        if (!collate) {
            p.uncollate();
        }
        return p.split(numContextLines);
    }

    private static Patch make(List<String> lines, Operation op2) {
        Patch patch = new Patch();
        patch.diffs = FastStream.of(lines).map(l -> new Diff(op2, (String)l)).toList();
        patch.recalculateLength();
        return patch;
    }

    public CharRepresenter getCharRep() {
        return this.charRep;
    }
}

