/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.BigArrays;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectArrays;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectCollection;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectIterator;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectList;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.objects.ObjectListIterator;

public final class ObjectIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private ObjectIterators() {
    }

    public static <K> ObjectIterator<K> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <K> ObjectListIterator<K> singleton(K element) {
        return new SingletonIterator<K>(element);
    }

    public static <K> ObjectListIterator<K> wrap(K[] array, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator<K>(array, offset, length);
    }

    public static <K> ObjectListIterator<K> wrap(K[] array) {
        return new ArrayIterator<K>(array, 0, array.length);
    }

    public static <K> int unwrap(Iterator<? extends K> i2, K[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            array[offset++] = i2.next();
        }
        return max - j - 1;
    }

    public static <K> int unwrap(Iterator<? extends K> i2, K[] array) {
        return ObjectIterators.unwrap(i2, array, 0, array.length);
    }

    public static <K> K[] unwrap(Iterator<? extends K> i2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        Object[] array = new Object[16];
        int j = 0;
        while (max-- != 0 && i2.hasNext()) {
            if (j == array.length) {
                array = ObjectArrays.grow(array, j + 1);
            }
            array[j++] = i2.next();
        }
        return ObjectArrays.trim(array, j);
    }

    public static <K> K[] unwrap(Iterator<? extends K> i2) {
        return ObjectIterators.unwrap(i2, Integer.MAX_VALUE);
    }

    public static <K> long unwrap(Iterator<? extends K> i2, K[][] array, long offset, long max) {
        if (max < 0L) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0L || offset + max > BigArrays.length(array)) {
            throw new IllegalArgumentException();
        }
        long j = max;
        while (j-- != 0L && i2.hasNext()) {
            BigArrays.set(array, offset++, i2.next());
        }
        return max - j - 1L;
    }

    public static <K> long unwrap(Iterator<? extends K> i2, K[][] array) {
        return ObjectIterators.unwrap(i2, array, 0L, BigArrays.length(array));
    }

    public static <K> int unwrap(Iterator<K> i2, ObjectCollection<? super K> c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            c.add(i2.next());
        }
        return max - j - 1;
    }

    public static <K> K[][] unwrapBig(Iterator<? extends K> i2, long max) {
        if (max < 0L) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        Object[][] array = ObjectBigArrays.newBigArray(16L);
        long j = 0L;
        while (max-- != 0L && i2.hasNext()) {
            if (j == BigArrays.length(array)) {
                array = BigArrays.grow(array, j + 1L);
            }
            BigArrays.set(array, j++, i2.next());
        }
        return BigArrays.trim(array, j);
    }

    public static <K> K[][] unwrapBig(Iterator<? extends K> i2) {
        return ObjectIterators.unwrapBig(i2, Long.MAX_VALUE);
    }

    public static <K> long unwrap(Iterator<K> i2, ObjectCollection<? super K> c) {
        long n = 0L;
        while (i2.hasNext()) {
            c.add(i2.next());
            ++n;
        }
        return n;
    }

    public static <K> int pour(Iterator<K> i2, ObjectCollection<? super K> s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            s.add(i2.next());
        }
        return max - j - 1;
    }

    public static <K> int pour(Iterator<K> i2, ObjectCollection<? super K> s) {
        return ObjectIterators.pour(i2, s, Integer.MAX_VALUE);
    }

    public static <K> ObjectList<K> pour(Iterator<K> i2, int max) {
        ObjectArrayList l = new ObjectArrayList();
        ObjectIterators.pour(i2, l, max);
        l.trim();
        return l;
    }

    public static <K> ObjectList<K> pour(Iterator<K> i2) {
        return ObjectIterators.pour(i2, Integer.MAX_VALUE);
    }

    public static <K> ObjectIterator<K> asObjectIterator(Iterator<K> i2) {
        if (i2 instanceof ObjectIterator) {
            return (ObjectIterator)i2;
        }
        return new IteratorWrapper<K>(i2);
    }

    public static <K> ObjectListIterator<K> asObjectIterator(ListIterator<K> i2) {
        if (i2 instanceof ObjectListIterator) {
            return (ObjectListIterator)i2;
        }
        return new ListIteratorWrapper<K>(i2);
    }

    public static <K> boolean any(ObjectIterator<K> iterator, Predicate<? super K> predicate) {
        return ObjectIterators.indexOf(iterator, predicate) != -1;
    }

    public static <K> boolean all(ObjectIterator<K> iterator, Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate);
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (predicate.test(iterator.next()));
        return false;
    }

    public static <K> int indexOf(ObjectIterator<K> iterator, Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate);
        int i2 = 0;
        while (iterator.hasNext()) {
            if (predicate.test(iterator.next())) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static <K> ObjectIterator<K> concat(ObjectIterator<? extends K>[] a) {
        return ObjectIterators.concat(a, 0, a.length);
    }

    public static <K> ObjectIterator<K> concat(ObjectIterator<? extends K>[] a, int offset, int length) {
        return new IteratorConcatenator<K>(a, offset, length);
    }

    public static <K> ObjectIterator<K> unmodifiable(ObjectIterator<K> i2) {
        return new UnmodifiableIterator<K>(i2);
    }

    public static <K> ObjectBidirectionalIterator<K> unmodifiable(ObjectBidirectionalIterator<K> i2) {
        return new UnmodifiableBidirectionalIterator<K>(i2);
    }

    public static <K> ObjectListIterator<K> unmodifiable(ObjectListIterator<K> i2) {
        return new UnmodifiableListIterator<K>(i2);
    }

    public static class EmptyIterator<K>
    implements ObjectListIterator<K>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public K next() {
            throw new NoSuchElementException();
        }

        @Override
        public K previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public int skip(int n) {
            return 0;
        }

        @Override
        public int back(int n) {
            return 0;
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_ITERATOR;
        }
    }

    private static class SingletonIterator<K>
    implements ObjectListIterator<K> {
        private final K element;
        private int curr;

        public SingletonIterator(K element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public K previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class ArrayIterator<K>
    implements ObjectListIterator<K> {
        private final K[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(K[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        @Override
        public K previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        @Override
        public int skip(int n) {
            if (n <= this.length - this.curr) {
                this.curr += n;
                return n;
            }
            n = this.length - this.curr;
            this.curr = this.length;
            return n;
        }

        @Override
        public int back(int n) {
            if (n <= this.curr) {
                this.curr -= n;
                return n;
            }
            n = this.curr;
            this.curr = 0;
            return n;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class IteratorWrapper<K>
    implements ObjectIterator<K> {
        final Iterator<K> i;

        public IteratorWrapper(Iterator<K> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public K next() {
            return this.i.next();
        }
    }

    private static class ListIteratorWrapper<K>
    implements ObjectListIterator<K> {
        final ListIterator<K> i;

        public ListIteratorWrapper(ListIterator<K> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(K k) {
            this.i.set(k);
        }

        @Override
        public void add(K k) {
            this.i.add(k);
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public K next() {
            return this.i.next();
        }

        @Override
        public K previous() {
            return this.i.previous();
        }
    }

    private static class IteratorConcatenator<K>
    implements ObjectIterator<K> {
        final ObjectIterator<? extends K>[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(ObjectIterator<? extends K>[] a, int offset, int length) {
            this.a = a;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            Object next = this.a[this.lastOffset].next();
            this.advance();
            return (K)next;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        @Override
        public int skip(int n) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n && this.length != 0) {
                skipped += this.a[this.offset].skip(n - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    public static class UnmodifiableIterator<K>
    implements ObjectIterator<K> {
        protected final ObjectIterator<K> i;

        public UnmodifiableIterator(ObjectIterator<K> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public K next() {
            return (K)this.i.next();
        }
    }

    public static class UnmodifiableBidirectionalIterator<K>
    implements ObjectBidirectionalIterator<K> {
        protected final ObjectBidirectionalIterator<K> i;

        public UnmodifiableBidirectionalIterator(ObjectBidirectionalIterator<K> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public K next() {
            return (K)this.i.next();
        }

        @Override
        public K previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableListIterator<K>
    implements ObjectListIterator<K> {
        protected final ObjectListIterator<K> i;

        public UnmodifiableListIterator(ObjectListIterator<K> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public K next() {
            return (K)this.i.next();
        }

        @Override
        public K previous() {
            return this.i.previous();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }
    }
}

