/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.com.google.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.TypeAdapter;
import paper.libs.com.google.gson.TypeAdapterFactory;
import paper.libs.com.google.gson.annotations.SerializedName;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.com.google.gson.stream.JsonReader;
import paper.libs.com.google.gson.stream.JsonToken;
import paper.libs.com.google.gson.stream.JsonWriter;

class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken2) {
            Class<T> rawType = typeToken2.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            EnumTypeAdapter adapter = new EnumTypeAdapter(rawType);
            return adapter;
        }
    };
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<String, T> stringToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();

    private EnumTypeAdapter(Class<T> classOfT) {
        try {
            AccessibleObject[] fields = classOfT.getDeclaredFields();
            int constantCount = 0;
            for (Field field : fields) {
                if (!field.isEnumConstant()) continue;
                fields[constantCount++] = field;
            }
            fields = Arrays.copyOf(fields, constantCount);
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject accessibleObject : fields) {
                Enum constant = (Enum)((Field)accessibleObject).get(null);
                String name2 = constant.name();
                String toStringVal = constant.toString();
                SerializedName annotation = ((Field)accessibleObject).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    name2 = annotation.value();
                    for (String alternate : annotation.alternate()) {
                        this.nameToConstant.put(alternate, constant);
                    }
                }
                this.nameToConstant.put(name2, constant);
                this.stringToConstant.put(toStringVal, constant);
                this.constantToName.put(constant, name2);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String key = in.nextString();
        Enum constant = (Enum)this.nameToConstant.get(key);
        return (T)(constant == null ? (Enum)this.stringToConstant.get(key) : constant);
    }

    @Override
    public void write(JsonWriter out, T value2) throws IOException {
        out.value(value2 == null ? null : this.constantToName.get(value2));
    }
}

