/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm.hydrate;

import java.io.IOException;
import paper.libs.dev.denwav.hypo.asm.AsmMethodData;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.hydrate.HydrationProvider;
import paper.libs.dev.denwav.hypo.hydrate.generic.HypoHydration;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.MethodDescriptor;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.tree.AbstractInsnNode;
import paper.libs.org.objectweb.asm.tree.LabelNode;
import paper.libs.org.objectweb.asm.tree.LineNumberNode;
import paper.libs.org.objectweb.asm.tree.MethodInsnNode;
import paper.libs.org.objectweb.asm.tree.TypeInsnNode;
import paper.libs.org.objectweb.asm.tree.VarInsnNode;

public class BridgeMethodHydrator
implements HydrationProvider<AsmMethodData> {
    private BridgeMethodHydrator() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static BridgeMethodHydrator create() {
        return new BridgeMethodHydrator();
    }

    @Override
    @NotNull
    public Class<? extends AsmMethodData> target() {
        return AsmMethodData.class;
    }

    @Override
    public void hydrate(@NotNull AsmMethodData data, @NotNull HypoContext context) throws IOException {
        if (!data.isSynthetic() || !data.isBridge() || data.name().indexOf(36) != -1) {
            return;
        }
        State state = State.IN_PARAMS;
        int nextLvt = 0;
        MethodInsnNode invokeInsn = null;
        for (AbstractInsnNode insn : data.getNode().instructions) {
            if (insn instanceof LabelNode || insn instanceof LineNumberNode || insn instanceof TypeInsnNode) continue;
            if (!(state != State.IN_PARAMS || insn instanceof VarInsnNode && ((VarInsnNode)insn).var == nextLvt)) {
                state = State.INVOKE;
            }
            int opcode = insn.getOpcode();
            switch (state) {
                case IN_PARAMS: {
                    ++nextLvt;
                    if (opcode != 22 && opcode != 24) break;
                    ++nextLvt;
                    break;
                }
                case INVOKE: {
                    if (opcode != 182 && opcode != 185 || !(insn instanceof MethodInsnNode)) {
                        return;
                    }
                    invokeInsn = (MethodInsnNode)insn;
                    state = State.RETURN;
                    break;
                }
                case RETURN: {
                    if (opcode < 172 || opcode > 177) {
                        return;
                    }
                    state = State.OTHER_INSN;
                    break;
                }
                case OTHER_INSN: {
                    return;
                }
            }
        }
        if (invokeInsn == null) {
            return;
        }
        @NotNull MethodInsnNode invoke2 = invokeInsn;
        if (invoke2.name.indexOf(36) != -1) {
            return;
        }
        if (!data.parentClass().getNode().name.equals(invoke2.owner) || data.name().equals(invoke2.name) && data.getNode().desc.equals(invoke2.desc)) {
            return;
        }
        MethodDescriptor invokeDesc = MethodDescriptor.parseDescriptor(invoke2.desc);
        if (data.params().size() != invokeDesc.getParams().size()) {
            return;
        }
        MethodData targetMethod = data.parentClass().method(invoke2.name, invokeDesc);
        if (targetMethod == null) {
            return;
        }
        data.store(HypoHydration.SYNTHETIC_TARGET, targetMethod);
        targetMethod.store(HypoHydration.SYNTHETIC_SOURCE, data);
    }

    static enum State {
        IN_PARAMS,
        INVOKE,
        RETURN,
        OTHER_INSN;

    }
}

