/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm.hydrate;

import java.util.ArrayDeque;
import java.util.Objects;
import paper.libs.dev.denwav.hypo.asm.hydrate.MethodCallArgument;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.Type;

final class MethodCall
implements MethodCallArgument {
    @NotNull
    final ArrayDeque<MethodCallArgument> args = new ArrayDeque();
    @Nullable
    MethodCallArgument receiver;
    @Nullable
    String owner;
    @Nullable
    String desc;

    MethodCall() {
    }

    void collapseInvoke(int argCount, boolean isStatic, @Nullable String owner, @NotNull String desc) {
        int count2;
        int back = argCount + (isStatic ? 0 : 1);
        if (back == (count2 = this.args.size())) {
            this.receiver = this.args.removeFirst();
            this.owner = owner;
            this.desc = desc;
            return;
        }
        if (back > count2) {
            throw new IllegalStateException("Cannot collapse args - requested " + back + " args but only have " + count2);
        }
        MethodCall innerCall = new MethodCall();
        for (int i2 = 0; i2 < argCount; ++i2) {
            innerCall.args.addFirst(this.args.removeLast());
        }
        if (!isStatic) {
            innerCall.receiver = this.args.removeLast();
        }
        if (Objects.equals(Type.getReturnType(desc), Type.VOID_TYPE)) {
            this.args.removeLast();
        }
        this.args.addLast(innerCall);
        innerCall.owner = owner;
        innerCall.desc = desc;
    }
}

