/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.core.HypoException;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributorSet;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.InnerClassMapping;
import paper.libs.org.cadixdev.lorenz.model.TopLevelClassMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;

public class MappingsCompletionManager {
    @NotNull
    private final HypoContext context;

    private MappingsCompletionManager(@NotNull HypoContext context) {
        this.context = context;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MappingsCompletionManager create(@NotNull HypoContext context) {
        return new MappingsCompletionManager(context);
    }

    @NotNull
    public ChangeRegistry completeMappings(@NotNull MappingSet mappings, @NotNull @NotNull List<@NotNull ChangeContributor> contributors) throws HypoException {
        ChangeContributor contrib = ChangeContributorSet.wrap(contributors);
        ChangeRegistry registry = new ChangeRegistry();
        HashSet<String> visitedClasses = new HashSet<String>();
        registry.setCurrentContributorName(contrib.name());
        ExecutorService executor = this.context.getExecutor();
        ArrayList futures = new ArrayList();
        for (TopLevelClassMapping topLevelClassMapping : mappings.getTopLevelClassMappings()) {
            this.complete(topLevelClassMapping, contrib, visitedClasses, executor, futures, registry);
        }
        for (ClassData classData : this.context.getProvider().allClasses()) {
            if (visitedClasses.contains(classData.name())) continue;
            futures.add(executor.submit(() -> {
                try {
                    contrib.contribute(classData, null, this.context, registry);
                }
                catch (Throwable e) {
                    throw new HypoException("Error while contributing mappings changes with '" + contrib.name() + "' for: " + classData.name(), e);
                }
                return null;
            }));
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HypoException("Mappings completion execution failed", e);
        }
        return registry;
    }

    private void complete(@NotNull ClassMapping<?, ?> mappings, @NotNull ChangeContributor contributor, @NotNull HashSet<String> visitedClasses, @NotNull ExecutorService executor, @NotNull ArrayList<Future<?>> futures, @NotNull ChangeRegistry registry) {
        String className = mappings.getFullObfuscatedName();
        visitedClasses.add(className);
        futures.add(executor.submit(() -> {
            ClassData classData;
            try {
                classData = this.context.getProvider().findClass(className);
            }
            catch (IOException e) {
                throw new HypoException("Error while attempting to find class: " + className, e);
            }
            try {
                contributor.contribute(classData, mappings, this.context, registry);
            }
            catch (Throwable e) {
                throw new HypoException("Error while contributing mappings changes with '" + contributor.name() + "' for: " + className, e);
            }
            return null;
        }));
        for (InnerClassMapping innerMapping : mappings.getInnerClassMappings()) {
            this.complete(innerMapping, contributor, visitedClasses, executor, futures, registry);
        }
    }
}

