/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.changes;

import java.util.ArrayList;
import java.util.List;
import paper.libs.dev.denwav.hypo.hydrate.generic.SuperCall;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.MergeResult;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;

public class CopyConstructorMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<CopyConstructorMappingChange> {
    @NotNull
    private final MethodMapping superMapping;
    @NotNull
    private final List<SuperCall.SuperCallParameter> params = new ArrayList<SuperCall.SuperCallParameter>();

    private CopyConstructorMappingChange(@NotNull MemberReference target, @NotNull MethodMapping superMapping) {
        super(target);
        this.superMapping = superMapping;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static CopyConstructorMappingChange of(@NotNull MemberReference target, @NotNull MethodMapping superMapping) {
        return new CopyConstructorMappingChange(target, superMapping);
    }

    @NotNull
    public MethodMapping superMapping() {
        return this.superMapping;
    }

    @NotNull
    public List<SuperCall.SuperCallParameter> params() {
        return this.params;
    }

    public void addParams(@NotNull List<SuperCall.SuperCallParameter> params) {
        this.params.addAll(params);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        if (target.desc() == null) {
            return;
        }
        ClassMapping<?, ?> classMapping = input.getOrCreateClassMapping(target.className());
        MethodMapping targetMapping = classMapping.getOrCreateMethodMapping(target.name(), target.desc());
        for (SuperCall.SuperCallParameter param : this.params) {
            MethodParameterMapping paramMapping = LorenzUtil.getParameterMapping(this.superMapping, param.getSuperIndex());
            if (paramMapping == null) continue;
            targetMapping.getOrCreateParameterMapping(param.getThisIndex()).setDeobfuscatedName(paramMapping.getDeobfuscatedName());
        }
    }

    @Override
    @NotNull
    public MergeResult<CopyConstructorMappingChange> mergeWith(@NotNull CopyConstructorMappingChange that) {
        if (!this.superMapping.getDescriptor().equals(that.superMapping.getDescriptor())) {
            return MergeResult.failure("Cannot merge constructor mappings changes with different super constructor mappings: " + this.superMapping + " and " + that.superMapping);
        }
        for (SuperCall.SuperCallParameter param : that.params) {
            boolean isDupe = this.params.stream().anyMatch(p -> p.getThisIndex() == param.getThisIndex() ^ p.getSuperIndex() == param.getSuperIndex());
            if (!isDupe) continue;
            return MergeResult.failure("Cannot merge super call with duplicate parameter indexes: " + this.params + " and " + that.params);
        }
        this.params.addAll(that.params);
        return MergeResult.success(this);
    }

    public String toString() {
        return "Copy constructor mapping '" + this.superMapping.getFullDeobfuscatedName() + "' to " + this.target();
    }
}

