/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import paper.libs.dev.denwav.hypo.model.ClassDataDecorator;
import paper.libs.dev.denwav.hypo.model.ClassDataProvider;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public class ClassDataProviderSet
implements ClassDataProvider {
    @NotNull
    private final @NotNull List<? extends @NotNull ClassDataProvider> delegateProviders;

    private ClassDataProviderSet(@NotNull @NotNull List<? extends @NotNull ClassDataProvider> delegateProviders) {
        this.delegateProviders = delegateProviders;
    }

    @Contract(value="_ -> new")
    public static ClassDataProviderSet wrap(@NotNull @NotNull Collection<? extends @NotNull ClassDataProvider> providers) {
        return new ClassDataProviderSet(HypoModelUtil.asImmutableList(providers));
    }

    @Override
    public void setDecorator(@NotNull ClassDataDecorator decorator) {
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            classDataProvider.setDecorator(decorator);
        }
    }

    @Override
    public void setContextClassProvider(boolean contextClassProvider) {
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            classDataProvider.setContextClassProvider(contextClassProvider);
        }
    }

    @Override
    public boolean isContextClassProvider() {
        boolean isContext = false;
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            isContext |= classDataProvider.isContextClassProvider();
        }
        return isContext;
    }

    @Override
    public void setRequireFullClasspath(boolean requireFullClasspath) {
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            classDataProvider.setRequireFullClasspath(requireFullClasspath);
        }
    }

    @Override
    public boolean isRequireFullClasspath() {
        boolean isRequireFullClasspath = false;
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            isRequireFullClasspath |= classDataProvider.isRequireFullClasspath();
        }
        return isRequireFullClasspath;
    }

    @Override
    @Contract(value="null -> null")
    @Nullable
    public ClassData findClass(@Nullable String className) throws IOException {
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            ClassData data = classDataProvider.findClass(className);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    @Override
    @NotNull
    public Stream<ClassData> stream() throws IOException {
        return this.delegateProviders.stream().flatMap(HypoModelUtil.wrapFunction(ClassDataProvider::stream));
    }

    @Override
    public void close() throws Exception {
        Exception thrown = null;
        for (ClassDataProvider classDataProvider : this.delegateProviders) {
            try {
                classDataProvider.close();
            }
            catch (Exception e) {
                thrown = HypoModelUtil.addSuppressed(thrown, e);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

