/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import paper.libs.com.google.errorprone.annotations.concurrent.LazyInit;
import paper.libs.dev.denwav.hypo.model.ClassDataProvider;
import paper.libs.dev.denwav.hypo.model.data.AbstractHypoData;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public abstract class AbstractClassData
extends AbstractHypoData
implements ClassData {
    @LazyInit
    @Nullable
    protected ClassDataProvider provider = null;
    private boolean isContextClass = false;
    private boolean isRequireFullClasspath = false;
    @NotNull
    private final @NotNull Set<@NotNull ClassData> childClasses = new LinkedHashSet<ClassData>();
    @NotNull
    private final @NotNull Set<@NotNull ClassData> innerClasses = new LinkedHashSet<ClassData>();

    @Override
    public void setProvider(@NotNull ClassDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setContextClass(boolean contextClass) {
        this.isContextClass = contextClass;
    }

    @Override
    public boolean isContextClass() {
        return this.isContextClass;
    }

    @Override
    public void setRequireFullClasspath(boolean requireFullClasspath) {
        this.isRequireFullClasspath = requireFullClasspath;
    }

    @Override
    public boolean isRequireFullClasspath() {
        return this.isRequireFullClasspath;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ClassData> childClasses() {
        return this.childClasses;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ClassData> innerClasses() {
        return this.innerClasses;
    }

    @NotNull
    protected ClassDataProvider prov() {
        if (this.provider == null) {
            throw new NullPointerException("ClassDataProvider not set on " + this.name());
        }
        return this.provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassData)) {
            return false;
        }
        ClassData that = (ClassData)o;
        return this.name().equals(that.name());
    }

    public int hashCode() {
        return Objects.hash(this.name());
    }

    public String toString() {
        return this.name();
    }
}

