/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import paper.libs.dev.denwav.hypo.model.ClassDataProvider;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.dev.denwav.hypo.model.data.ClassKind;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.HypoData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.MethodDescriptor;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public interface ClassData
extends HypoData {
    public void setProvider(@NotNull ClassDataProvider var1);

    public void setContextClass(boolean var1);

    public boolean isContextClass();

    public void setRequireFullClasspath(boolean var1);

    public boolean isRequireFullClasspath();

    @NotNull
    public String name();

    @Nullable
    public ClassData outerClass() throws IOException;

    public boolean isStaticInnerClass();

    public boolean isFinal();

    public boolean isSynthetic();

    @NotNull
    public ClassKind kind();

    @NotNull
    public Visibility visibility();

    @Nullable
    public ClassData superClass() throws IOException;

    @NotNull
    public Set<ClassData> interfaces() throws IOException;

    @NotNull
    default public @NotNull Stream<@NotNull ClassData> allSuperClasses() throws IOException {
        ClassData superClass = this.superClass();
        Set<ClassData> superInterfaces = this.interfaces();
        if (superClass == null && superInterfaces.isEmpty()) {
            return Stream.empty();
        }
        if (superClass == null) {
            return superInterfaces.stream();
        }
        if (superInterfaces.isEmpty()) {
            return Stream.of(superClass);
        }
        ClassData[] res = new ClassData[superInterfaces.size() + 1];
        res[0] = superClass;
        int index = 1;
        for (ClassData superInterface : superInterfaces) {
            res[index++] = superInterface;
        }
        return Arrays.stream(res);
    }

    default public <X extends Throwable> void forEachSuperClass(@NotNull @NotNull HypoModelUtil.ThrowingConsumer<@NotNull ClassData, X> consumer) throws IOException, X {
        ClassData superClass = this.superClass();
        if (superClass != null) {
            consumer.acceptThrowing(superClass);
        }
        for (ClassData superInter : this.interfaces()) {
            consumer.acceptThrowing(superInter);
        }
    }

    @NotNull
    public Set<FieldData> fields();

    @NotNull
    public Set<MethodData> methods();

    default public boolean doesExtend(@NotNull ClassData that) {
        if (this.equals(that)) {
            return true;
        }
        try {
            ClassData superClass = this.superClass();
            if (superClass != null) {
                return superClass.doesExtend(that);
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return false;
    }

    default public boolean doesImplement(@NotNull ClassData that) {
        if (this.equals(that)) {
            return true;
        }
        try {
            for (ClassData iface : this.interfaces()) {
                if (iface == null) continue;
                return iface.doesExtend(that);
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return false;
    }

    default public boolean doesExtendOrImplement(@NotNull ClassData that) {
        if (this.equals(that)) {
            return true;
        }
        try {
            return this.allSuperClasses().anyMatch(s -> s.doesExtendOrImplement(that));
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @NotNull
    default public @NotNull Set<@NotNull FieldData> fields(@NotNull String name2) {
        LinkedHashSet<FieldData> result2 = null;
        FieldData singleResult = null;
        for (FieldData field : this.fields()) {
            if (!field.name().equals(name2)) continue;
            if (singleResult == null) {
                singleResult = field;
                continue;
            }
            if (result2 == null) {
                result2 = new LinkedHashSet<FieldData>();
                result2.add(singleResult);
                result2.add(field);
                continue;
            }
            result2.add(field);
        }
        if (result2 != null) {
            return Collections.unmodifiableSet(result2);
        }
        if (singleResult != null) {
            return Collections.singleton(singleResult);
        }
        return Collections.emptySet();
    }

    @Nullable
    default public FieldData field(@NotNull String name2, @NotNull JvmType type) {
        for (FieldData field : this.fields()) {
            if (!field.name().equals(name2) || !field.fieldType().equals(type)) continue;
            return field;
        }
        return null;
    }

    @NotNull
    default public @NotNull Set<@NotNull MethodData> methods(@NotNull String name2) {
        LinkedHashSet<MethodData> result2 = null;
        MethodData singleResult = null;
        for (MethodData method : this.methods()) {
            if (!method.name().equals(name2)) continue;
            if (singleResult == null) {
                singleResult = method;
                continue;
            }
            if (result2 == null) {
                result2 = new LinkedHashSet<MethodData>();
                result2.add(singleResult);
                result2.add(method);
                continue;
            }
            result2.add(method);
        }
        if (result2 != null) {
            return Collections.unmodifiableSet(result2);
        }
        if (singleResult != null) {
            return Collections.singleton(singleResult);
        }
        return Collections.emptySet();
    }

    @Nullable
    default public MethodData method(@NotNull String name2, @NotNull MethodDescriptor descriptor) {
        for (MethodData method : this.methods()) {
            if (!method.name().equals(name2) || !method.descriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public @NotNull Set<@NotNull ClassData> childClasses();

    @NotNull
    public @NotNull Set<@NotNull ClassData> innerClasses();
}

