/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data.types;

import java.util.Objects;
import paper.libs.com.google.errorprone.annotations.Immutable;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.dev.denwav.hypo.model.data.types.PrimitiveType;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Immutable
public final class ClassType
implements JvmType {
    @NotNull
    private final String className;

    public ClassType(@NotNull String className) {
        this.className = HypoModelUtil.normalizedClassName(className);
    }

    @Override
    public void asReadableName(@NotNull StringBuilder sb) {
        sb.append(this.className.replace('/', '.'));
    }

    @Override
    public void asInternalName(@NotNull StringBuilder sb) {
        sb.append('L').append(this.className).append(';');
    }

    @Nullable
    public PrimitiveType toPrimitiveType() {
        for (PrimitiveType value2 : PrimitiveType.values()) {
            if (!value2.toWrapperType().equals(this)) continue;
            return value2;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassType)) {
            return false;
        }
        ClassType classType = (ClassType)o;
        return this.className.equals(classType.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }

    public String toString() {
        return this.asReadableName();
    }
}

