/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.net.fabricmc.mappings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import paper.libs.net.fabricmc.mappings.ClassEntry;
import paper.libs.net.fabricmc.mappings.EntryTriple;
import paper.libs.net.fabricmc.mappings.FieldEntry;
import paper.libs.net.fabricmc.mappings.MappedStringDeduplicator;
import paper.libs.net.fabricmc.mappings.Mappings;
import paper.libs.net.fabricmc.mappings.MethodEntry;
import paper.libs.org.objectweb.asm.commons.Remapper;

@Deprecated
class TinyMappings
implements Mappings {
    private final Map<String, Integer> namespacesToIds;
    private final List<ClassEntryImpl> classEntries;
    private final List<EntryImpl> fieldEntries;
    private final List<EntryImpl> methodEntries;

    @Deprecated
    protected TinyMappings(InputStream stream) throws IOException {
        this(stream, new MappedStringDeduplicator.MapBased());
    }

    protected TinyMappings(InputStream stream, MappedStringDeduplicator deduplicator) throws IOException {
        try (InputStreamReader streamReader = new InputStreamReader(stream);
             BufferedReader reader = new BufferedReader(streamReader);){
            String line;
            String[] header = reader.readLine().split("\t");
            if (header.length <= 1 || !header[0].equals("v1")) {
                throw new IOException("Invalid mapping version!");
            }
            String[] namespaceList = new String[header.length - 1];
            this.namespacesToIds = new HashMap<String, Integer>();
            for (int i2 = 1; i2 < header.length; ++i2) {
                namespaceList[i2 - 1] = header[i2];
                if (this.namespacesToIds.containsKey(header[i2])) {
                    throw new IOException("Duplicate namespace: " + header[i2]);
                }
                this.namespacesToIds.put(header[i2], i2 - 1);
            }
            this.classEntries = new ArrayList<ClassEntryImpl>();
            String firstNamespace = header[1];
            HashMap<String, ClassEntryImpl> firstNamespaceClassEntries = new HashMap<String, ClassEntryImpl>();
            ArrayList<String[]> fieldLines = new ArrayList<String[]>();
            ArrayList<String[]> methodLines = new ArrayList<String[]>();
            while ((line = reader.readLine()) != null) {
                String[] splitLine = line.split("\t");
                if (splitLine.length < 2) continue;
                switch (splitLine[0]) {
                    case "CLASS": {
                        ClassEntryImpl entry = new ClassEntryImpl(this.namespacesToIds, deduplicator, splitLine, namespaceList);
                        this.classEntries.add(entry);
                        firstNamespaceClassEntries.put(entry.get(firstNamespace), entry);
                        break;
                    }
                    case "FIELD": {
                        fieldLines.add(splitLine);
                        break;
                    }
                    case "METHOD": {
                        methodLines.add(splitLine);
                    }
                }
            }
            this.fieldEntries = new ArrayList<EntryImpl>(fieldLines.size());
            this.methodEntries = new ArrayList<EntryImpl>(methodLines.size());
            HashMap<String, ClassRemapper> targetRemappers = new HashMap<String, ClassRemapper>();
            for (int i3 = 1; i3 < namespaceList.length; ++i3) {
                targetRemappers.put(namespaceList[i3], new ClassRemapper(firstNamespaceClassEntries, namespaceList[i3]));
            }
            for (String[] splitLine : fieldLines) {
                this.fieldEntries.add(new EntryImpl(this.namespacesToIds, deduplicator, splitLine, namespaceList, targetRemappers, false));
            }
            for (String[] splitLine : methodLines) {
                this.methodEntries.add(new EntryImpl(this.namespacesToIds, deduplicator, splitLine, namespaceList, targetRemappers, false));
            }
            ((ArrayList)this.classEntries).trimToSize();
        }
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.namespacesToIds.keySet();
    }

    @Override
    public Collection<ClassEntry> getClassEntries() {
        return this.classEntries;
    }

    @Override
    public Collection<FieldEntry> getFieldEntries() {
        return this.fieldEntries;
    }

    @Override
    public Collection<MethodEntry> getMethodEntries() {
        return this.methodEntries;
    }

    private static class ClassRemapper
    extends Remapper {
        private final Map<String, ClassEntryImpl> firstNamespaceClassEntries;
        private final String destinationNamespace;

        ClassRemapper(Map<String, ClassEntryImpl> firstNamespaceClassEntries, String destinationNamespace) {
            this.firstNamespaceClassEntries = firstNamespaceClassEntries;
            this.destinationNamespace = destinationNamespace;
        }

        @Override
        public String map(String typeName) {
            String out;
            ClassEntryImpl entry = this.firstNamespaceClassEntries.get(typeName);
            if (entry != null && (out = entry.get(this.destinationNamespace)) != null) {
                return out;
            }
            return typeName;
        }
    }

    private static class EntryImpl
    implements FieldEntry,
    MethodEntry {
        private final Map<String, Integer> namespacesToIds;
        private final EntryTriple[] names;

        EntryImpl(Map<String, Integer> namespacesToIds, MappedStringDeduplicator deduplicator, String[] data, String[] namespaceList, Map<String, ClassRemapper> targetRemappers, boolean isMethod) {
            MappedStringDeduplicator.Category descCategory = isMethod ? MappedStringDeduplicator.Category.METHOD_DESCRIPTOR : MappedStringDeduplicator.Category.FIELD_DESCRIPTOR;
            this.namespacesToIds = namespacesToIds;
            this.names = new EntryTriple[namespaceList.length];
            this.names[0] = new EntryTriple(deduplicator.deduplicate(MappedStringDeduplicator.Category.CLASS_NAME, data[1]), deduplicator.deduplicate(MappedStringDeduplicator.Category.NAME, data[3]), deduplicator.deduplicate(descCategory, data[2]));
            for (int i2 = 1; i2 < namespaceList.length; ++i2) {
                String target = namespaceList[i2];
                String mappedOwner = targetRemappers.get(target).map(data[1]);
                String mappedDesc = isMethod ? targetRemappers.get(target).mapMethodDesc(data[2]) : targetRemappers.get(target).mapDesc(data[2]);
                this.names[i2] = new EntryTriple(mappedOwner, deduplicator.deduplicate(MappedStringDeduplicator.Category.NAME, data[3 + i2]), deduplicator.deduplicate(descCategory, mappedDesc));
            }
        }

        @Override
        public EntryTriple get(String namespace) {
            return this.names[this.namespacesToIds.get(namespace)];
        }
    }

    private static class ClassEntryImpl
    implements ClassEntry {
        private final Map<String, Integer> namespacesToIds;
        private final String[] names;

        ClassEntryImpl(Map<String, Integer> namespacesToIds, MappedStringDeduplicator deduplicator, String[] data, String[] namespaceList) {
            this.namespacesToIds = namespacesToIds;
            this.names = new String[namespaceList.length];
            for (int i2 = 0; i2 < namespaceList.length; ++i2) {
                this.names[i2] = deduplicator.deduplicate(MappedStringDeduplicator.Category.CLASS_NAME, data[i2 + 1]);
            }
        }

        @Override
        public String get(String namespace) {
            return this.names[this.namespacesToIds.get(namespace)];
        }
    }
}

