/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.http.impl.cookie;

import java.util.Date;
import paper.libs.org.apache.http.annotation.Contract;
import paper.libs.org.apache.http.annotation.ThreadingBehavior;
import paper.libs.org.apache.http.client.utils.DateUtils;
import paper.libs.org.apache.http.cookie.CommonCookieAttributeHandler;
import paper.libs.org.apache.http.cookie.MalformedCookieException;
import paper.libs.org.apache.http.cookie.SetCookie;
import paper.libs.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import paper.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datePatterns;

    public BasicExpiresHandler(String[] datePatterns) {
        Args.notNull(datePatterns, "Array of date patterns");
        this.datePatterns = (String[])datePatterns.clone();
    }

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value2, this.datePatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

