/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.http.impl.cookie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import paper.libs.org.apache.http.annotation.Contract;
import paper.libs.org.apache.http.annotation.ThreadingBehavior;
import paper.libs.org.apache.http.conn.util.PublicSuffixList;
import paper.libs.org.apache.http.conn.util.PublicSuffixMatcher;
import paper.libs.org.apache.http.cookie.CommonCookieAttributeHandler;
import paper.libs.org.apache.http.cookie.Cookie;
import paper.libs.org.apache.http.cookie.CookieOrigin;
import paper.libs.org.apache.http.cookie.MalformedCookieException;
import paper.libs.org.apache.http.cookie.SetCookie;
import paper.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final Map<String, Boolean> localDomainMap;

    private static Map<String, Boolean> createLocalDomainMap() {
        ConcurrentHashMap<String, Boolean> map2 = new ConcurrentHashMap<String, Boolean>();
        map2.put(".localhost.", Boolean.TRUE);
        map2.put(".test.", Boolean.TRUE);
        map2.put(".local.", Boolean.TRUE);
        map2.put(".local", Boolean.TRUE);
        map2.put(".localdomain", Boolean.TRUE);
        return map2;
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(handler, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixList suffixList) {
        Args.notNull(handler, "Cookie handler");
        Args.notNull(suffixList, "Public suffix list");
        this.handler = handler;
        this.publicSuffixMatcher = new PublicSuffixMatcher(suffixList.getRules(), suffixList.getExceptions());
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        String domain;
        String host = cookie.getDomain();
        if (host == null) {
            return false;
        }
        int i2 = host.indexOf(46);
        if (i2 >= 0 ? !this.localDomainMap.containsKey(domain = host.substring(i2)) && this.publicSuffixMatcher.matches(host) : !host.equalsIgnoreCase(origin.getHost()) && this.publicSuffixMatcher.matches(host)) {
            return false;
        }
        return this.handler.match(cookie, origin);
    }

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        this.handler.parse(cookie, value2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        this.handler.validate(cookie, origin);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(handler, "Cookie attribute handler");
        return publicSuffixMatcher != null ? new PublicSuffixDomainFilter(handler, publicSuffixMatcher) : handler;
    }
}

