/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.at.io.fml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.function.BiConsumer;
import paper.libs.org.cadixdev.at.AccessChange;
import paper.libs.org.cadixdev.at.AccessTransform;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;

final class FmlWriter {
    private static final char WILDCARD = '*';
    private static final String METHOD_WILDCARD = "*()";
    private final BufferedWriter writer;

    FmlWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    void write(AccessTransformSet set) throws IOException {
        set.getClasses().forEach(FmlWriter.throwing((originalClassName, classSet) -> {
            String className = originalClassName.replace('/', '.');
            this.writeClass(className, classSet.get());
            this.writeField(className, null, classSet.allFields());
            classSet.getFields().forEach(FmlWriter.throwing((name2, transform2) -> this.writeField(className, (String)name2, (AccessTransform)transform2)));
            this.writeMethod(className, null, classSet.allMethods());
            classSet.getMethods().forEach(FmlWriter.throwing((name2, transform2) -> this.writeMethod(className, (MethodSignature)name2, (AccessTransform)transform2)));
        }));
    }

    private static String getAccessModifier(AccessChange change) {
        switch (change) {
            case PUBLIC: {
                return "public";
            }
            case PROTECTED: {
                return "protected";
            }
            case PACKAGE_PRIVATE: {
                return "default";
            }
            case PRIVATE: {
                return "private";
            }
        }
        throw new AssertionError((Object)change);
    }

    private void writeAccessTransform(String className, AccessTransform transform2) throws IOException {
        if (transform2.getAccess() != AccessChange.NONE) {
            this.writer.write(FmlWriter.getAccessModifier(transform2.getAccess()));
        }
        switch (transform2.getFinal()) {
            case NONE: {
                break;
            }
            case REMOVE: {
                this.writer.write("-f");
                break;
            }
            case ADD: {
                this.writer.write("+f");
                break;
            }
            default: {
                throw new AssertionError((Object)transform2.getFinal());
            }
        }
        this.writer.write(32);
        this.writer.write(className);
    }

    private void writeClass(String className, AccessTransform transform2) throws IOException {
        if (transform2.isEmpty()) {
            return;
        }
        this.writeAccessTransform(className, transform2);
        this.writer.newLine();
    }

    private void writeField(String className, String name2, AccessTransform transform2) throws IOException {
        if (transform2.isEmpty()) {
            return;
        }
        this.writeAccessTransform(className, transform2);
        this.writer.write(32);
        if (name2 != null) {
            this.writer.write(name2);
        } else {
            this.writer.write(42);
        }
        this.writer.newLine();
    }

    private void writeMethod(String className, MethodSignature signature, AccessTransform transform2) throws IOException {
        if (transform2.isEmpty()) {
            return;
        }
        this.writeAccessTransform(className, transform2);
        this.writer.write(32);
        if (signature != null) {
            this.writer.write(signature.getName());
            this.writer.write(signature.getDescriptor().toString());
        } else {
            this.writer.write(METHOD_WILDCARD);
        }
        this.writer.newLine();
    }

    private static <T, U> BiConsumer<T, U> throwing(ThrowingBiConsumer<T, U> consumer) {
        return consumer;
    }

    private static interface ThrowingBiConsumer<T, U>
    extends BiConsumer<T, U> {
        public void throwingAccept(T var1, U var2) throws IOException;

        @Override
        default public void accept(T t, U u) {
            try {
                this.throwingAccept(t, u);
            }
            catch (IOException e) {
                ThrowingBiConsumer.rethrow(e);
            }
        }

        public static <E extends Exception> void rethrow(Exception e) throws E {
            throw e;
        }
    }
}

