/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.atlas.jar;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import paper.libs.org.cadixdev.atlas.jar.JarPath;
import paper.libs.org.cadixdev.atlas.jar.JarVisitOption;
import paper.libs.org.cadixdev.atlas.util.NIOHelper;
import paper.libs.org.cadixdev.bombe.asm.jar.ClassProvider;
import paper.libs.org.cadixdev.bombe.jar.AbstractJarEntry;
import paper.libs.org.cadixdev.bombe.jar.JarClassEntry;
import paper.libs.org.cadixdev.bombe.jar.JarEntryTransformer;
import paper.libs.org.cadixdev.bombe.jar.JarManifestEntry;
import paper.libs.org.cadixdev.bombe.jar.JarResourceEntry;
import paper.libs.org.cadixdev.bombe.jar.JarServiceProviderConfigurationEntry;
import paper.libs.org.cadixdev.bombe.jar.ServiceProviderConfiguration;

public class JarFile
implements ClassProvider,
Closeable {
    private final Path path;
    private final FileSystem fs;
    private final Map<JarPath, JarClassEntry> cache = new ConcurrentHashMap<JarPath, JarClassEntry>();

    public JarFile(Path path) throws IOException {
        this.path = path;
        this.fs = NIOHelper.openZip(this.path, false);
    }

    public String getName() {
        return this.path.toString();
    }

    public AbstractJarEntry get(JarPath path) throws IOException {
        Path entry = this.fs.getPath("/", path.getName());
        if (Files.notExists(entry, new LinkOption[0])) {
            return null;
        }
        if ("META-INF/MANIFEST.MF".equals(path.getName())) {
            return JarFile._readManifest(entry);
        }
        if (path.getName().startsWith("META-INF/services/")) {
            return JarFile._readServiceConfig(entry);
        }
        if (path.getName().endsWith(".class")) {
            return this.getClass(path);
        }
        return JarFile._readResource(entry);
    }

    public JarClassEntry getClass(JarPath path) {
        return this.cache.computeIfAbsent(path, p -> {
            Path entry = this.fs.getPath("/", p.getName());
            if (Files.notExists(entry, new LinkOption[0])) {
                return null;
            }
            try {
                return JarFile._readClass(entry);
            }
            catch (IOException ignored) {
                return null;
            }
        });
    }

    public JarClassEntry getClass(String name2) {
        return this.getClass(new JarPath(name2));
    }

    public Stream<JarPath> walk(JarVisitOption ... options) throws IOException {
        return Files.walk(this.fs.getPath("/", new String[0]), new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> {
            String name2 = p.toString().substring(1);
            if ("META-INF/MANIFEST.MF".equals(name2) ? JarFile._contains(JarVisitOption.IGNORE_MANIFESTS, options) : (name2.startsWith("META-INF/services/") ? JarFile._contains(JarVisitOption.IGNORE_SERVICE_PROVIDER_CONFIGURATIONS, options) : (name2.endsWith(".class") ? JarFile._contains(JarVisitOption.IGNORE_CLASSES, options) : JarFile._contains(JarVisitOption.IGNORE_RESOURCES, options)))) {
                return null;
            }
            return new JarPath(name2);
        }).filter(Objects::nonNull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Path export, JarEntryTransformer ... transformers) throws IOException {
        ExecutorService executorService = Executors.newWorkStealingPool();
        try {
            this.transform(export, executorService, transformers);
        }
        finally {
            executorService.shutdown();
        }
    }

    public void transform(Path export, ExecutorService executorService, JarEntryTransformer ... transformers) throws IOException {
        Files.deleteIfExists(export);
        try (FileSystem fs = NIOHelper.openZip(export, true);){
            CompletableFuture<Void> future = CompletableFuture.allOf((CompletableFuture[])this.walk(new JarVisitOption[0]).map(path -> CompletableFuture.runAsync(() -> {
                try {
                    AbstractJarEntry entry = this.get((JarPath)path);
                    if (entry == null) {
                        return;
                    }
                    for (JarEntryTransformer transformer : transformers) {
                        if ((entry = entry.accept(transformer)) != null) continue;
                        return;
                    }
                    Path outEntry = fs.getPath("/", entry.getName());
                    Files.createDirectories(outEntry.getParent(), new FileAttribute[0]);
                    Files.write(outEntry, entry.getContents(), new OpenOption[0]);
                    Files.setLastModifiedTime(outEntry, FileTime.fromMillis(entry.getTime()));
                }
                catch (IOException ex) {
                    throw new CompletionException(ex);
                }
            }, executorService)).toArray(CompletableFuture[]::new));
            future.get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            try {
                throw ex.getCause();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable cause) {
                throw new RuntimeException(cause);
            }
        }
    }

    @Override
    public byte[] get(String klass) {
        JarClassEntry entry = this.getClass(klass + ".class");
        return entry == null ? null : entry.getContents();
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    private static JarManifestEntry _readManifest(Path entry) throws IOException {
        long time = Files.getLastModifiedTime(entry, new LinkOption[0]).toMillis();
        try (InputStream is = Files.newInputStream(entry, new OpenOption[0]);){
            JarManifestEntry jarManifestEntry = new JarManifestEntry(time, new Manifest(is));
            return jarManifestEntry;
        }
    }

    private static JarServiceProviderConfigurationEntry _readServiceConfig(Path entry) throws IOException {
        String name2 = entry.toString().substring(1);
        long time = Files.getLastModifiedTime(entry, new LinkOption[0]).toMillis();
        try (InputStream is = Files.newInputStream(entry, new OpenOption[0]);){
            String serviceName = name2.substring("META-INF/services/".length());
            ServiceProviderConfiguration config = new ServiceProviderConfiguration(serviceName);
            config.read(is);
            JarServiceProviderConfigurationEntry jarServiceProviderConfigurationEntry = new JarServiceProviderConfigurationEntry(time, config);
            return jarServiceProviderConfigurationEntry;
        }
    }

    private static JarClassEntry _readClass(Path entry) throws IOException {
        String name2 = entry.toString().substring(1);
        long time = Files.getLastModifiedTime(entry, new LinkOption[0]).toMillis();
        return new JarClassEntry(name2, time, Files.readAllBytes(entry));
    }

    private static JarResourceEntry _readResource(Path entry) throws IOException {
        String name2 = entry.toString().substring(1);
        long time = Files.getLastModifiedTime(entry, new LinkOption[0]).toMillis();
        return new JarResourceEntry(name2, time, Files.readAllBytes(entry));
    }

    private static <T> boolean _contains(T entry, T[] in) {
        for (T i2 : in) {
            if (i2 != entry) continue;
            return true;
        }
        return false;
    }
}

