/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.io.proguard;

import paper.libs.me.jamiemansfield.string.StringReader;
import paper.libs.org.cadixdev.bombe.type.ArrayType;
import paper.libs.org.cadixdev.bombe.type.BaseType;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.bombe.type.ObjectType;
import paper.libs.org.cadixdev.bombe.type.Type;
import paper.libs.org.cadixdev.bombe.type.VoidType;

public class PGTypeReader
extends StringReader {
    public PGTypeReader(String source) {
        super(source);
    }

    public Type readType() {
        if (this.match("void")) {
            return VoidType.INSTANCE;
        }
        return this.readFieldType();
    }

    public FieldType readFieldType() {
        while (this.available() && this.peek() != '[') {
            this.advance();
        }
        FieldType type = PGTypeReader.getType(this.substring(0, this.index()));
        if (!this.available()) {
            return type;
        }
        int dims = 0;
        while (this.available()) {
            if (this.advance() != '[') continue;
            ++dims;
        }
        return new ArrayType(dims, type);
    }

    private boolean match(String raw) {
        for (int i2 = 0; i2 < raw.toCharArray().length; ++i2) {
            if (raw.toCharArray()[i2] == this.peek(i2)) continue;
            return false;
        }
        return true;
    }

    private static FieldType getType(String raw) {
        if ("byte".equals(raw)) {
            return BaseType.BYTE;
        }
        if ("char".equals(raw)) {
            return BaseType.CHAR;
        }
        if ("double".equals(raw)) {
            return BaseType.DOUBLE;
        }
        if ("float".equals(raw)) {
            return BaseType.FLOAT;
        }
        if ("int".equals(raw)) {
            return BaseType.INT;
        }
        if ("long".equals(raw)) {
            return BaseType.LONG;
        }
        if ("short".equals(raw)) {
            return BaseType.SHORT;
        }
        if ("boolean".equals(raw)) {
            return BaseType.BOOLEAN;
        }
        return new ObjectType(raw);
    }
}

