/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.io.srg;

import java.io.Reader;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.io.TextMappingsReader;
import paper.libs.org.cadixdev.lorenz.io.srg.SrgConstants;

public class SrgReader
extends TextMappingsReader {
    public SrgReader(Reader reader) {
        super(reader, Processor::new);
    }

    public static class Processor
    extends TextMappingsReader.Processor {
        private static final String PACKAGE_MAPPING_KEY = "PK:";
        private static final String CLASS_MAPPING_KEY = "CL:";
        private static final String FIELD_MAPPING_KEY = "FD:";
        private static final String METHOD_MAPPING_KEY = "MD:";
        private static final int PACKAGE_MAPPING_ELEMENT_COUNT = 3;
        private static final int CLASS_MAPPING_ELEMENT_COUNT = 3;
        private static final int FIELD_MAPPING_ELEMENT_COUNT = 3;
        private static final int METHOD_MAPPING_ELEMENT_COUNT = 5;

        public Processor(MappingSet mappings) {
            super(mappings);
        }

        public Processor() {
            this(MappingSet.create());
        }

        @Override
        public void accept(String rawLine) {
            String line = SrgConstants.removeComments(rawLine).trim();
            if (line.isEmpty()) {
                return;
            }
            if (line.length() < 4) {
                throw new IllegalArgumentException("Faulty SRG mapping encountered: `" + line + "`!");
            }
            String[] split = SPACE.split(line);
            int len = split.length;
            String key = split[0];
            if (key.equals(CLASS_MAPPING_KEY) && len == 3) {
                String obfuscatedName = split[1];
                String deobfuscatedName = split[2];
                this.mappings.getOrCreateClassMapping(obfuscatedName).setDeobfuscatedName(deobfuscatedName);
            } else if (key.equals(FIELD_MAPPING_KEY) && len == 3) {
                String fullObfuscatedName = split[1];
                String fullDeobfuscatedName = split[2];
                int lastIndex = fullObfuscatedName.lastIndexOf(47);
                String owningClass = fullObfuscatedName.substring(0, lastIndex);
                String obfuscatedName = fullObfuscatedName.substring(lastIndex + 1);
                String deobfuscatedName = fullDeobfuscatedName.substring(fullDeobfuscatedName.lastIndexOf(47) + 1);
                this.mappings.getOrCreateClassMapping(owningClass).getOrCreateFieldMapping(obfuscatedName).setDeobfuscatedName(deobfuscatedName);
            } else if (key.equals(METHOD_MAPPING_KEY) && len == 5) {
                String fullObfuscatedName = split[1];
                String obfuscatedSignature = split[2];
                String fullDeobfuscatedName = split[3];
                String deobfuscatedSignature = split[4];
                int lastIndex = fullObfuscatedName.lastIndexOf(47);
                String owningClass = fullObfuscatedName.substring(0, lastIndex);
                String obfuscatedName = fullObfuscatedName.substring(lastIndex + 1);
                String deobfuscatedName = fullDeobfuscatedName.substring(fullDeobfuscatedName.lastIndexOf(47) + 1);
                this.mappings.getOrCreateClassMapping(owningClass).getOrCreateMethodMapping(obfuscatedName, obfuscatedSignature).setDeobfuscatedName(deobfuscatedName);
            } else if (!key.equals(PACKAGE_MAPPING_KEY) || len != 3) {
                throw new IllegalArgumentException("Found unrecognised key: `" + key + "`!");
            }
        }
    }
}

