/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.graph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphType;
import paper.libs.org.jgrapht.graph.GraphSpecificsStrategy;
import paper.libs.org.jgrapht.graph.IntrusiveEdgesSpecifics;
import paper.libs.org.jgrapht.graph.UniformIntrusiveEdgesSpecifics;
import paper.libs.org.jgrapht.graph.WeightedIntrusiveEdgesSpecifics;
import paper.libs.org.jgrapht.graph.specifics.FastLookupDirectedSpecifics;
import paper.libs.org.jgrapht.graph.specifics.FastLookupUndirectedSpecifics;
import paper.libs.org.jgrapht.graph.specifics.Specifics;

public class FastLookupGraphSpecificsStrategy<V, E>
implements GraphSpecificsStrategy<V, E> {
    private static final long serialVersionUID = -5490869870275054280L;

    @Override
    public Function<GraphType, IntrusiveEdgesSpecifics<V, E>> getIntrusiveEdgesSpecificsFactory() {
        return (Function<GraphType, IntrusiveEdgesSpecifics> & Serializable)type -> {
            if (type.isWeighted()) {
                return new WeightedIntrusiveEdgesSpecifics(new LinkedHashMap());
            }
            return new UniformIntrusiveEdgesSpecifics(new LinkedHashMap());
        };
    }

    @Override
    public BiFunction<Graph<V, E>, GraphType, Specifics<V, E>> getSpecificsFactory() {
        return (BiFunction<Graph, GraphType, Specifics> & Serializable)(graph, type) -> {
            if (type.isDirected()) {
                return new FastLookupDirectedSpecifics(graph, new LinkedHashMap(), new HashMap(), this.getEdgeSetFactory());
            }
            return new FastLookupUndirectedSpecifics(graph, new LinkedHashMap(), new HashMap(), this.getEdgeSetFactory());
        };
    }
}

