/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.tukaani.xz;

import java.io.InputStream;
import paper.libs.org.tukaani.xz.FilterDecoder;
import paper.libs.org.tukaani.xz.LZMA2Coder;
import paper.libs.org.tukaani.xz.LZMA2InputStream;
import paper.libs.org.tukaani.xz.UnsupportedOptionsException;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] byArray2) throws UnsupportedOptionsException {
        if (byArray2.length != 1 || (byArray2[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | byArray2[0] & 1;
        this.dictSize <<= (byArray2[0] >>> 1) + 11;
    }

    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    public InputStream getInputStream(InputStream inputStream) {
        return new LZMA2InputStream(inputStream, this.dictSize);
    }
}

