/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.tukaani.xz.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import paper.libs.org.tukaani.xz.CorruptedInputException;
import paper.libs.org.tukaani.xz.UnsupportedOptionsException;
import paper.libs.org.tukaani.xz.XZ;
import paper.libs.org.tukaani.xz.XZFormatException;
import paper.libs.org.tukaani.xz.common.StreamFlags;
import paper.libs.org.tukaani.xz.common.Util;

public class DecoderUtil
extends Util {
    public static boolean isCRC32Valid(byte[] byArray2, int n, int n2, int n3) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray2, n, n2);
        long l = cRC32.getValue();
        for (int j = 0; j < 4; ++j) {
            if ((byte)(l >>> j * 8) == byArray2[n3 + j]) continue;
            return false;
        }
        return true;
    }

    public static StreamFlags decodeStreamHeader(byte[] byArray2) throws IOException {
        for (int j = 0; j < XZ.HEADER_MAGIC.length; ++j) {
            if (byArray2[j] == XZ.HEADER_MAGIC[j]) continue;
            throw new XZFormatException();
        }
        if (!DecoderUtil.isCRC32Valid(byArray2, XZ.HEADER_MAGIC.length, 2, XZ.HEADER_MAGIC.length + 2)) {
            throw new CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return DecoderUtil.decodeStreamFlags(byArray2, XZ.HEADER_MAGIC.length);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static StreamFlags decodeStreamFooter(byte[] byArray2) throws IOException {
        StreamFlags streamFlags;
        if (byArray2[10] != XZ.FOOTER_MAGIC[0] || byArray2[11] != XZ.FOOTER_MAGIC[1]) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!DecoderUtil.isCRC32Valid(byArray2, 4, 6, 0)) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            streamFlags = DecoderUtil.decodeStreamFlags(byArray2, 8);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        streamFlags.backwardSize = 0L;
        for (int j = 0; j < 4; ++j) {
            streamFlags.backwardSize |= (long)((byArray2[j + 4] & 0xFF) << j * 8);
        }
        streamFlags.backwardSize = (streamFlags.backwardSize + 1L) * 4L;
        return streamFlags;
    }

    private static StreamFlags decodeStreamFlags(byte[] byArray2, int n) throws UnsupportedOptionsException {
        if (byArray2[n] != 0 || (byArray2[n + 1] & 0xFF) >= 16) {
            throw new UnsupportedOptionsException();
        }
        StreamFlags streamFlags = new StreamFlags();
        streamFlags.checkType = byArray2[n + 1];
        return streamFlags;
    }

    public static boolean areStreamFlagsEqual(StreamFlags streamFlags, StreamFlags streamFlags2) {
        return streamFlags.checkType == streamFlags2.checkType;
    }

    public static long decodeVLI(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        long l = n & 0x7F;
        int n2 = 0;
        while ((n & 0x80) != 0) {
            if (++n2 >= 9) {
                throw new CorruptedInputException();
            }
            n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            if (n == 0) {
                throw new CorruptedInputException();
            }
            l |= (long)(n & 0x7F) << n2 * 7;
        }
        return l;
    }
}

